/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.util.Iterator;
import java.util.Objects;
import org.apache.qpid.server.util.PeekingIterator;

public class PeekingIteratorImpl<E>
implements PeekingIterator<E> {
    private final Iterator<? extends E> iterator;
    private boolean hasPeeked;
    private E peekedElement;

    public PeekingIteratorImpl(Iterator<? extends E> iterator) {
        Objects.requireNonNull(iterator);
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.hasPeeked || this.iterator.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasPeeked) {
            return this.iterator.next();
        }
        E result = this.peekedElement;
        this.hasPeeked = false;
        this.peekedElement = null;
        return result;
    }

    @Override
    public void remove() {
        if (!this.hasPeeked) {
            throw new IllegalStateException("Can't remove after you've peeked at next");
        }
        this.iterator.remove();
    }

    @Override
    public E peek() {
        if (!this.hasPeeked) {
            this.peekedElement = this.iterator.next();
            this.hasPeeked = true;
        }
        return this.peekedElement;
    }
}

