/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.factory;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.logic.AndExpression;
import org.apache.qpid.server.query.engine.parsing.expression.logic.ExpressionWrapperExpression;
import org.apache.qpid.server.query.engine.parsing.expression.logic.NotExpression;
import org.apache.qpid.server.query.engine.parsing.expression.logic.OrExpression;
import org.apache.qpid.server.query.engine.parsing.expression.logic.PredicateWrapperExpression;
import org.apache.qpid.server.query.engine.parsing.utils.StringUtils;

public final class LogicExpressionFactory {
    private LogicExpressionFactory() {
    }

    public static <T, R> AndExpression<T> and(String alias, ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        return new AndExpression<T>(alias, left, right);
    }

    public static <T, R> OrExpression<T> or(String alias, ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        return new OrExpression<T>(alias, left, right);
    }

    public static <T, R> Predicate<T> toPredicate(ExpressionNode<T, R> expression) {
        Objects.requireNonNull(expression, "Child expression should be not null");
        if (expression instanceof Predicate) {
            return (Predicate)((Object)expression);
        }
        return new PredicateWrapperExpression<T, R>(expression);
    }

    public static <T> Expression<T, Boolean> toFunction(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "Child expression should be not null");
        if (predicate instanceof Expression) {
            return (Expression)((Object)predicate);
        }
        return new ExpressionWrapperExpression<T>(predicate);
    }

    public static <T, R> NotExpression<T, R> negate(Expression<T, R> value) {
        Objects.requireNonNull(value, "Child expression should be not null");
        if (!(value instanceof Predicate)) {
            throw QueryParsingException.of("Negation of '%s' not supported", StringUtils.getClassName(value));
        }
        return new NotExpression<T, R>(value);
    }
}

