/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server.internal;

import java.util.List;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.core.server.internal.WebSocketNegotiation;

public class ServerUpgradeRequestImpl
extends Request.Wrapper
implements ServerUpgradeRequest {
    private final Request request;
    private final WebSocketNegotiation negotiation;

    public ServerUpgradeRequestImpl(WebSocketNegotiation negotiation, Request baseRequest) throws BadMessageException {
        super(baseRequest);
        this.negotiation = negotiation;
        this.request = baseRequest;
    }

    @Override
    public WebSocketComponents getWebSocketComponents() {
        return this.negotiation.getWebSocketComponents();
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.negotiation.getOfferedExtensions();
    }

    @Override
    public String getProtocolVersion() {
        String version = this.request.getHeaders().get(HttpHeader.SEC_WEBSOCKET_VERSION.asString());
        if (version == null) {
            return Integer.toString(13);
        }
        return version;
    }

    @Override
    public List<String> getSubProtocols() {
        return this.negotiation.getOfferedSubprotocols();
    }

    @Override
    public boolean hasSubProtocol(String subprotocol) {
        for (String protocol : this.getSubProtocols()) {
            if (!protocol.equalsIgnoreCase(subprotocol)) continue;
            return true;
        }
        return false;
    }
}

