/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.Base64Variants;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TreeNode;
import tools.jackson.core.Version;
import tools.jackson.core.Versioned;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.core.exc.StreamWriteException;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.core.util.JacksonFeatureSet;

public abstract class JsonGenerator
implements Closeable,
Flushable,
Versioned {
    protected JsonGenerator() {
    }

    @Override
    public abstract Version version();

    public StreamWriteConstraints streamWriteConstraints() {
        return StreamWriteConstraints.defaults();
    }

    public abstract TokenStreamContext streamWriteContext();

    public abstract ObjectWriteContext objectWriteContext();

    public abstract Object streamWriteOutputTarget();

    public abstract int streamWriteOutputBuffered();

    public abstract Object currentValue();

    public abstract void assignCurrentValue(Object var1);

    public abstract JsonGenerator configure(StreamWriteFeature var1, boolean var2);

    public abstract boolean isEnabled(StreamWriteFeature var1);

    public abstract int streamWriteFeatures();

    public FormatSchema getSchema() {
        return null;
    }

    public int getHighestNonEscapedChar() {
        return 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes esc) {
        return this;
    }

    public PrettyPrinter getPrettyPrinter() {
        return null;
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public boolean canOmitProperties() {
        return true;
    }

    public abstract boolean has(StreamWriteCapability var1);

    public abstract JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities();

    public abstract JsonGenerator writeStartArray() throws JacksonException;

    public abstract JsonGenerator writeStartArray(Object var1) throws JacksonException;

    public abstract JsonGenerator writeStartArray(Object var1, int var2) throws JacksonException;

    public abstract JsonGenerator writeEndArray() throws JacksonException;

    public abstract JsonGenerator writeStartObject() throws JacksonException;

    public abstract JsonGenerator writeStartObject(Object var1) throws JacksonException;

    public abstract JsonGenerator writeStartObject(Object var1, int var2) throws JacksonException;

    public abstract JsonGenerator writeEndObject() throws JacksonException;

    public abstract JsonGenerator writeName(String var1) throws JacksonException;

    public abstract JsonGenerator writeName(SerializableString var1) throws JacksonException;

    public abstract JsonGenerator writePropertyId(long var1) throws JacksonException;

    public JsonGenerator writeArray(int[] array, int offset, int length) throws JacksonException {
        Objects.requireNonNull(array, "null 'array' argument");
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray(array, length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.writeNumber(array[i]);
        }
        this.writeEndArray();
        return this;
    }

    public JsonGenerator writeArray(long[] array, int offset, int length) throws JacksonException {
        Objects.requireNonNull(array, "null 'array' argument");
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray(array, length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.writeNumber(array[i]);
        }
        this.writeEndArray();
        return this;
    }

    public JsonGenerator writeArray(double[] array, int offset, int length) throws JacksonException {
        Objects.requireNonNull(array, "null 'array' argument");
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray(array, length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.writeNumber(array[i]);
        }
        this.writeEndArray();
        return this;
    }

    public JsonGenerator writeArray(String[] array, int offset, int length) throws JacksonException {
        Objects.requireNonNull(array, "null 'array' argument");
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray(array, length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.writeString(array[i]);
        }
        this.writeEndArray();
        return this;
    }

    public abstract JsonGenerator writeString(String var1) throws JacksonException;

    public abstract JsonGenerator writeString(Reader var1, int var2) throws JacksonException;

    public abstract JsonGenerator writeString(char[] var1, int var2, int var3) throws JacksonException;

    public abstract JsonGenerator writeString(SerializableString var1) throws JacksonException;

    public abstract JsonGenerator writeRawUTF8String(byte[] var1, int var2, int var3) throws JacksonException;

    public abstract JsonGenerator writeUTF8String(byte[] var1, int var2, int var3) throws JacksonException;

    public abstract JsonGenerator writeRaw(String var1) throws JacksonException;

    public abstract JsonGenerator writeRaw(String var1, int var2, int var3) throws JacksonException;

    public abstract JsonGenerator writeRaw(char[] var1, int var2, int var3) throws JacksonException;

    public abstract JsonGenerator writeRaw(char var1) throws JacksonException;

    public JsonGenerator writeRaw(SerializableString raw) throws JacksonException {
        return this.writeRaw(raw.getValue());
    }

    public abstract JsonGenerator writeRawValue(String var1) throws JacksonException;

    public abstract JsonGenerator writeRawValue(String var1, int var2, int var3) throws JacksonException;

    public abstract JsonGenerator writeRawValue(char[] var1, int var2, int var3) throws JacksonException;

    public JsonGenerator writeRawValue(SerializableString raw) throws JacksonException {
        return this.writeRawValue(raw.getValue());
    }

    public abstract JsonGenerator writeBinary(Base64Variant var1, byte[] var2, int var3, int var4) throws JacksonException;

    public JsonGenerator writeBinary(byte[] data, int offset, int len) throws JacksonException {
        return this.writeBinary(Base64Variants.getDefaultVariant(), data, offset, len);
    }

    public JsonGenerator writeBinary(byte[] data) throws JacksonException {
        return this.writeBinary(Base64Variants.getDefaultVariant(), data, 0, data.length);
    }

    public int writeBinary(InputStream data, int dataLength) throws JacksonException {
        return this.writeBinary(Base64Variants.getDefaultVariant(), data, dataLength);
    }

    public abstract int writeBinary(Base64Variant var1, InputStream var2, int var3) throws JacksonException;

    public abstract JsonGenerator writeNumber(short var1) throws JacksonException;

    public abstract JsonGenerator writeNumber(int var1) throws JacksonException;

    public abstract JsonGenerator writeNumber(long var1) throws JacksonException;

    public abstract JsonGenerator writeNumber(BigInteger var1) throws JacksonException;

    public abstract JsonGenerator writeNumber(double var1) throws JacksonException;

    public abstract JsonGenerator writeNumber(float var1) throws JacksonException;

    public abstract JsonGenerator writeNumber(BigDecimal var1) throws JacksonException;

    public abstract JsonGenerator writeNumber(String var1) throws JacksonException;

    public JsonGenerator writeNumber(char[] encodedValueBuffer, int offset, int len) throws JacksonException {
        return this.writeNumber(new String(encodedValueBuffer, offset, len));
    }

    public abstract JsonGenerator writeBoolean(boolean var1) throws JacksonException;

    public abstract JsonGenerator writeNull() throws JacksonException;

    public JsonGenerator writeEmbeddedObject(Object object) throws JacksonException {
        if (object == null) {
            this.writeNull();
            return this;
        }
        if (object instanceof byte[]) {
            this.writeBinary((byte[])object);
            return this;
        }
        throw this._constructWriteException("No native support for writing embedded objects of type %s", object.getClass().getName());
    }

    public JsonGenerator writeObjectId(Object id) throws JacksonException {
        throw this._constructWriteException("No native support for writing Object Ids");
    }

    public JsonGenerator writeObjectRef(Object referenced) throws JacksonException {
        throw this._constructWriteException("No native support for writing Object Ids");
    }

    public JsonGenerator writeTypeId(Object id) throws JacksonException {
        throw this._constructWriteException("No native support for writing Type Ids");
    }

    public WritableTypeId writeTypePrefix(WritableTypeId typeIdDef) throws JacksonException {
        boolean wasStartObjectWritten = this.canWriteTypeId() ? this._writeTypePrefixUsingNative(typeIdDef) : this._writeTypePrefixUsingWrapper(typeIdDef);
        switch (typeIdDef.valueShape) {
            case START_OBJECT: {
                if (wasStartObjectWritten) break;
                this.writeStartObject(typeIdDef.forValue);
                break;
            }
            case START_ARRAY: {
                this.writeStartArray(typeIdDef.forValue);
                break;
            }
        }
        return typeIdDef;
    }

    protected boolean _writeTypePrefixUsingNative(WritableTypeId typeIdDef) throws JacksonException {
        typeIdDef.wrapperWritten = false;
        this.writeTypeId(typeIdDef.id);
        return false;
    }

    protected boolean _writeTypePrefixUsingWrapper(WritableTypeId typeIdDef) throws JacksonException {
        String id = Objects.toString(typeIdDef.id, null);
        if (id == null) {
            return false;
        }
        WritableTypeId.Inclusion incl = typeIdDef.include;
        if (typeIdDef.valueShape != JsonToken.START_OBJECT && incl.requiresObjectContext()) {
            typeIdDef.include = incl = WritableTypeId.Inclusion.WRAPPER_ARRAY;
        }
        typeIdDef.wrapperWritten = true;
        switch (incl) {
            case PARENT_PROPERTY: {
                break;
            }
            case PAYLOAD_PROPERTY: {
                break;
            }
            case METADATA_PROPERTY: {
                this.writeStartObject(typeIdDef.forValue);
                this.writeStringProperty(typeIdDef.asProperty, id);
                return true;
            }
            case WRAPPER_OBJECT: {
                this.writeStartObject();
                this.writeName(id);
                break;
            }
            default: {
                this.writeStartArray();
                this.writeString(id);
            }
        }
        return false;
    }

    public WritableTypeId writeTypeSuffix(WritableTypeId typeIdDef) throws JacksonException {
        JsonToken valueShape = typeIdDef.valueShape;
        if (valueShape == JsonToken.START_OBJECT) {
            this.writeEndObject();
        } else if (valueShape == JsonToken.START_ARRAY) {
            this.writeEndArray();
        }
        if (typeIdDef.wrapperWritten) {
            switch (typeIdDef.include) {
                case WRAPPER_ARRAY: {
                    this.writeEndArray();
                    break;
                }
                case PARENT_PROPERTY: {
                    Object id = typeIdDef.id;
                    String idStr = id instanceof String ? (String)id : String.valueOf(id);
                    this.writeStringProperty(typeIdDef.asProperty, idStr);
                    break;
                }
                case PAYLOAD_PROPERTY: 
                case METADATA_PROPERTY: {
                    break;
                }
                default: {
                    this.writeEndObject();
                }
            }
        }
        return typeIdDef;
    }

    public abstract JsonGenerator writePOJO(Object var1) throws JacksonException;

    public abstract JsonGenerator writeTree(TreeNode var1) throws JacksonException;

    public final JsonGenerator writeBinaryProperty(String propertyName, byte[] data) throws JacksonException {
        this.writeName(propertyName);
        return this.writeBinary(data);
    }

    public final JsonGenerator writeBooleanProperty(String propertyName, boolean value) throws JacksonException {
        this.writeName(propertyName);
        return this.writeBoolean(value);
    }

    public final JsonGenerator writeNullProperty(String propertyName) throws JacksonException {
        this.writeName(propertyName);
        return this.writeNull();
    }

    public final JsonGenerator writeStringProperty(String propertyName, String value) throws JacksonException {
        this.writeName(propertyName);
        return this.writeString(value);
    }

    public final JsonGenerator writeNumberProperty(String propertyName, short value) throws JacksonException {
        this.writeName(propertyName);
        return this.writeNumber(value);
    }

    public final JsonGenerator writeNumberProperty(String propertyName, int value) throws JacksonException {
        this.writeName(propertyName);
        return this.writeNumber(value);
    }

    public final JsonGenerator writeNumberProperty(String propertyName, long value) throws JacksonException {
        this.writeName(propertyName);
        return this.writeNumber(value);
    }

    public final JsonGenerator writeNumberProperty(String propertyName, BigInteger value) throws JacksonException {
        this.writeName(propertyName);
        return this.writeNumber(value);
    }

    public final JsonGenerator writeNumberProperty(String propertyName, float value) throws JacksonException {
        this.writeName(propertyName);
        return this.writeNumber(value);
    }

    public final JsonGenerator writeNumberProperty(String propertyName, double value) throws JacksonException {
        this.writeName(propertyName);
        return this.writeNumber(value);
    }

    public final JsonGenerator writeNumberProperty(String propertyName, BigDecimal value) throws JacksonException {
        this.writeName(propertyName);
        return this.writeNumber(value);
    }

    public final JsonGenerator writeArrayPropertyStart(String propertyName) throws JacksonException {
        this.writeName(propertyName);
        return this.writeStartArray();
    }

    public final JsonGenerator writeObjectPropertyStart(String propertyName) throws JacksonException {
        this.writeName(propertyName);
        return this.writeStartObject();
    }

    public final JsonGenerator writePOJOProperty(String propertyName, Object pojo) throws JacksonException {
        this.writeName(propertyName);
        return this.writePOJO(pojo);
    }

    public JsonGenerator writeOmittedProperty(String propertyName) throws JacksonException {
        return this;
    }

    public void copyCurrentEvent(JsonParser p) throws JacksonException {
        JsonToken t = p.currentToken();
        int token = t == null ? -1 : t.id();
        switch (token) {
            case -1: {
                this._reportError("No current event to copy");
                break;
            }
            case 1: {
                this.writeStartObject();
                break;
            }
            case 2: {
                this.writeEndObject();
                break;
            }
            case 3: {
                this.writeStartArray();
                break;
            }
            case 4: {
                this.writeEndArray();
                break;
            }
            case 5: {
                this.writeName(p.currentName());
                break;
            }
            case 6: {
                this._copyCurrentStringValue(p);
                break;
            }
            case 7: {
                this._copyCurrentIntValue(p);
                break;
            }
            case 8: {
                this._copyCurrentFloatValue(p);
                break;
            }
            case 9: {
                this.writeBoolean(true);
                break;
            }
            case 10: {
                this.writeBoolean(false);
                break;
            }
            case 11: {
                this.writeNull();
                break;
            }
            case 12: {
                this.writePOJO(p.getEmbeddedObject());
                break;
            }
            default: {
                throw new IllegalStateException("Internal error: unknown current token, " + String.valueOf((Object)t));
            }
        }
    }

    public void copyCurrentEventExact(JsonParser p) throws JacksonException {
        JsonToken t = p.currentToken();
        int token = t == null ? -1 : t.id();
        switch (token) {
            case -1: {
                this._reportError("No current event to copy");
                break;
            }
            case 1: {
                this.writeStartObject();
                break;
            }
            case 2: {
                this.writeEndObject();
                break;
            }
            case 3: {
                this.writeStartArray();
                break;
            }
            case 4: {
                this.writeEndArray();
                break;
            }
            case 5: {
                this.writeName(p.currentName());
                break;
            }
            case 6: {
                this._copyCurrentStringValue(p);
                break;
            }
            case 7: {
                this._copyCurrentIntValue(p);
                break;
            }
            case 8: {
                this._copyCurrentFloatValueExact(p);
                break;
            }
            case 9: {
                this.writeBoolean(true);
                break;
            }
            case 10: {
                this.writeBoolean(false);
                break;
            }
            case 11: {
                this.writeNull();
                break;
            }
            case 12: {
                this.writePOJO(p.getEmbeddedObject());
                break;
            }
            default: {
                throw new IllegalStateException("Internal error: unknown current token, " + String.valueOf((Object)t));
            }
        }
    }

    public void copyCurrentStructure(JsonParser p) throws JacksonException {
        int id;
        JsonToken t = p.currentToken();
        int n = id = t == null ? -1 : t.id();
        if (id == 5) {
            this.writeName(p.currentName());
            t = p.nextToken();
            id = t == null ? -1 : t.id();
        }
        switch (id) {
            case 1: {
                this.writeStartObject();
                this._copyCurrentContents(p);
                return;
            }
            case 3: {
                this.writeStartArray();
                this._copyCurrentContents(p);
                return;
            }
        }
        this.copyCurrentEvent(p);
    }

    public void copyCurrentStructureExact(JsonParser p) throws JacksonException {
        int id;
        JsonToken t = p.currentToken();
        int n = id = t == null ? -1 : t.id();
        if (id == 5) {
            this.writeName(p.currentName());
            t = p.nextToken();
            id = t == null ? -1 : t.id();
        }
        switch (id) {
            case 1: {
                this.writeStartObject();
                this._copyCurrentContentsExact(p);
                return;
            }
            case 3: {
                this.writeStartArray();
                this._copyCurrentContentsExact(p);
                return;
            }
        }
        this.copyCurrentEventExact(p);
    }

    protected void _copyCurrentContents(JsonParser p) throws JacksonException {
        JsonToken t;
        int depth = 1;
        block14: while ((t = p.nextToken()) != null) {
            switch (t.id()) {
                case 5: {
                    this.writeName(p.currentName());
                    continue block14;
                }
                case 3: {
                    this.writeStartArray();
                    ++depth;
                    continue block14;
                }
                case 1: {
                    this.writeStartObject();
                    ++depth;
                    continue block14;
                }
                case 4: {
                    this.writeEndArray();
                    if (--depth != 0) continue block14;
                    return;
                }
                case 2: {
                    this.writeEndObject();
                    if (--depth != 0) continue block14;
                    return;
                }
                case 6: {
                    this._copyCurrentStringValue(p);
                    continue block14;
                }
                case 7: {
                    this._copyCurrentIntValue(p);
                    continue block14;
                }
                case 8: {
                    this._copyCurrentFloatValue(p);
                    continue block14;
                }
                case 9: {
                    this.writeBoolean(true);
                    continue block14;
                }
                case 10: {
                    this.writeBoolean(false);
                    continue block14;
                }
                case 11: {
                    this.writeNull();
                    continue block14;
                }
                case 12: {
                    this.writePOJO(p.getEmbeddedObject());
                    continue block14;
                }
            }
            throw new IllegalStateException("Internal error: unknown current token, " + String.valueOf((Object)t));
        }
    }

    protected void _copyCurrentContentsExact(JsonParser p) throws JacksonException {
        JsonToken t;
        int depth = 1;
        block14: while ((t = p.nextToken()) != null) {
            switch (t.id()) {
                case 5: {
                    this.writeName(p.currentName());
                    continue block14;
                }
                case 3: {
                    this.writeStartArray();
                    ++depth;
                    continue block14;
                }
                case 1: {
                    this.writeStartObject();
                    ++depth;
                    continue block14;
                }
                case 4: {
                    this.writeEndArray();
                    if (--depth != 0) continue block14;
                    return;
                }
                case 2: {
                    this.writeEndObject();
                    if (--depth != 0) continue block14;
                    return;
                }
                case 6: {
                    this._copyCurrentStringValue(p);
                    continue block14;
                }
                case 7: {
                    this._copyCurrentIntValue(p);
                    continue block14;
                }
                case 8: {
                    this._copyCurrentFloatValueExact(p);
                    continue block14;
                }
                case 9: {
                    this.writeBoolean(true);
                    continue block14;
                }
                case 10: {
                    this.writeBoolean(false);
                    continue block14;
                }
                case 11: {
                    this.writeNull();
                    continue block14;
                }
                case 12: {
                    this.writePOJO(p.getEmbeddedObject());
                    continue block14;
                }
            }
            throw new IllegalStateException("Internal error: unknown current token, " + String.valueOf((Object)t));
        }
    }

    protected void _copyCurrentFloatValue(JsonParser p) throws JacksonException {
        JsonParser.NumberType t = p.getNumberType();
        if (t == JsonParser.NumberType.BIG_DECIMAL) {
            this.writeNumber(p.getDecimalValue());
        } else if (t == JsonParser.NumberType.FLOAT) {
            this.writeNumber(p.getFloatValue());
        } else {
            this.writeNumber(p.getDoubleValue());
        }
    }

    protected void _copyCurrentFloatValueExact(JsonParser p) throws JacksonException {
        Number n = p.getNumberValueExact();
        if (n instanceof BigDecimal) {
            this.writeNumber((BigDecimal)n);
        } else if (n instanceof Double) {
            this.writeNumber(n.doubleValue());
        } else {
            this.writeNumber(n.floatValue());
        }
    }

    protected void _copyCurrentIntValue(JsonParser p) throws JacksonException {
        JsonParser.NumberType n = p.getNumberType();
        if (n == JsonParser.NumberType.INT) {
            this.writeNumber(p.getIntValue());
        } else if (n == JsonParser.NumberType.LONG) {
            this.writeNumber(p.getLongValue());
        } else {
            this.writeNumber(p.getBigIntegerValue());
        }
    }

    protected void _copyCurrentStringValue(JsonParser p) throws JacksonException {
        if (p.hasStringCharacters()) {
            this.writeString(p.getStringCharacters(), p.getStringOffset(), p.getStringLength());
        } else {
            this.writeString(p.getString());
        }
    }

    @Override
    public abstract void flush();

    public abstract boolean isClosed();

    @Override
    public abstract void close();

    protected <T> T _reportError(String msg) throws StreamWriteException {
        throw this._constructWriteException(msg);
    }

    protected <T> T _reportUnsupportedOperation() {
        return this._reportUnsupportedOperation("Operation not supported by `JsonGenerator` of type " + this.getClass().getName());
    }

    protected <T> T _reportUnsupportedOperation(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    protected <T> T _reportArgumentError(String msg) throws StreamWriteException {
        return this._reportError(msg);
    }

    protected StreamWriteException _constructWriteException(String msg) {
        return new StreamWriteException(this, msg);
    }

    protected StreamWriteException _constructWriteException(String msg, Object arg) {
        return this._constructWriteException(String.format(msg, arg));
    }

    protected StreamWriteException _constructWriteException(String msg, Object arg1, Object arg2) {
        return this._constructWriteException(String.format(msg, arg1, arg2));
    }

    protected StreamWriteException _constructWriteException(String msg, Throwable t) {
        return new StreamWriteException(this, msg, t);
    }

    protected JacksonException _wrapIOFailure(IOException e) {
        return JacksonIOException.construct(e, this);
    }

    protected final void _verifyOffsets(int arrayLength, int offset, int length) {
        if (offset < 0 || offset + length > arrayLength) {
            throw new IllegalArgumentException(String.format("invalid argument(s) (offset=%d, length=%d) for input array of %d element", offset, length, arrayLength));
        }
    }
}

