/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;

public class SequenceNumber
implements Comparable<SequenceNumber> {
    private volatile int _seqNo;

    public SequenceNumber(int seqNo) {
        this._seqNo = seqNo;
    }

    public SequenceNumber incr() {
        ++this._seqNo;
        return this;
    }

    public SequenceNumber decr() {
        --this._seqNo;
        return this;
    }

    public SequenceNumber add(int i) {
        this._seqNo += i;
        return this;
    }

    public SequenceNumber subtract(int value) {
        this._seqNo -= value;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceNumber that = (SequenceNumber)o;
        return this._seqNo == that._seqNo;
    }

    public int hashCode() {
        return this._seqNo;
    }

    @Override
    public int compareTo(SequenceNumber o) {
        return this._seqNo - o._seqNo;
    }

    public String toString() {
        return "SN{" + this._seqNo + "}";
    }

    public int intValue() {
        return this._seqNo;
    }

    public long longValue() {
        return (long)this._seqNo & 0xFFFFFFFFL;
    }

    public UnsignedInteger unsignedIntegerValue() {
        return UnsignedInteger.valueOf(this._seqNo);
    }
}

