/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback.jdbc;

import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.security.FileKeyStore;
import org.apache.qpid.server.security.FileTrustStore;
import org.apache.qpid.server.store.jdbc.JDBCSettings;

public interface JDBCBrokerLogger<X extends JDBCBrokerLogger<X>>
extends BrokerLogger<X>,
JDBCSettings {
    public static final String BROKER_FAIL_ON_JDBC_LOGGER_ERROR = "qpid.broker.failOnJdbcLoggerError";
    @ManagedContextDefault(name="qpid.broker.failOnJdbcLoggerError")
    public static final String DEFAULT_BROKER_FAIL_ON_JDBC_LOGGER_ERROR = "false";

    @ManagedAttribute(mandatory=true)
    public String getConnectionUrl();

    @ManagedAttribute(defaultValue="NONE", validValues={"org.apache.qpid.server.store.jdbc.DefaultConnectionProviderFactory#getAllAvailableConnectionProviderTypes()"})
    public String getConnectionPoolType();

    @ManagedAttribute
    public String getUsername();

    @ManagedAttribute(secure=true)
    public String getPassword();

    @ManagedAttribute
    public String getTableNamePrefix();

    @ManagedAttribute(description="Optional keystore holding the key for secure database connection")
    public FileKeyStore<?> getKeyStore();

    @ManagedAttribute(description="Name of the database vendor specific keystore path property, property value is taken from the keystore")
    public String getKeyStorePathPropertyName();

    @ManagedAttribute(description="Name of the database vendor specific keystore password property, property value is taken from the keystore")
    public String getKeyStorePasswordPropertyName();

    @ManagedAttribute(description="Optional truststore holding the certificate for secure database connection")
    public FileTrustStore<?> getTrustStore();

    @ManagedAttribute(description="Name of the database vendor specific truststore path property, property value is taken from the truststore")
    public String getTrustStorePathPropertyName();

    @ManagedAttribute(description="Name of the database vendor specific truststore password property, property value is taken from the truststore")
    public String getTrustStorePasswordPropertyName();
}

