/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback.jdbc;

import ch.qos.logback.core.db.ConnectionSourceBase;
import ch.qos.logback.core.db.dialect.SQLDialectCode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;
import org.apache.qpid.server.store.jdbc.JDBCSettings;
import org.apache.qpid.server.store.jdbc.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSettingsDrivenConnectionSource
extends ConnectionSourceBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCSettingsDrivenConnectionSource.class);
    private final ConfiguredObject<?> _object;
    private final JDBCSettings _jdbcSettings;
    private final AtomicReference<ConnectionProvider> _connectionProvider;

    JDBCSettingsDrivenConnectionSource(ConfiguredObject<?> object, JDBCSettings jdbcSettings) {
        this._object = object;
        this._jdbcSettings = jdbcSettings;
        this._connectionProvider = new AtomicReference();
    }

    public Connection getConnection() throws SQLException {
        ConnectionProvider connectionProvider = this._connectionProvider.get();
        if (connectionProvider == null) {
            throw new IllegalConfigurationException("Connection provider does not exist");
        }
        return connectionProvider.getConnection();
    }

    public void start() {
        this._connectionProvider.getAndUpdate(provider -> provider == null ? this.create() : provider);
        this.discoverConnectionProperties();
        if (!this.supportsGetGeneratedKeys() && this.getSQLDialectCode() == SQLDialectCode.UNKNOWN_DIALECT) {
            this.addWarn("Connection does not support GetGeneratedKey method and could not discover the dialect.");
        }
        super.start();
    }

    public void stop() {
        super.stop();
        ConnectionProvider connectionProvider = this._connectionProvider.getAndSet(null);
        if (connectionProvider != null) {
            try {
                connectionProvider.close();
            }
            catch (SQLException e) {
                LOGGER.warn("Unable to close connection provider", (Throwable)e);
            }
        }
    }

    private ConnectionProvider create() {
        try {
            return JdbcUtils.createConnectionProvider(this._object, (JDBCSettings)this._jdbcSettings, (Logger)LOGGER);
        }
        catch (SQLException e) {
            throw new IllegalConfigurationException("Cannot create connection provider", (Throwable)e);
        }
    }

    public String toString() {
        return String.format("JDBCSettingsDrivenConnectionSource{_jdbcSettings=%s}", this._jdbcSettings);
    }
}

