/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.qpid.protonj2.client.LinkOptions;
import org.apache.qpid.protonj2.engine.DeliveryTagGenerator;

public class SenderOptions
extends LinkOptions<SenderOptions>
implements Cloneable {
    private long sendTimeout = -1L;
    private Supplier<DeliveryTagGenerator> tagGeneratorSupplier;

    public SenderOptions() {
    }

    public SenderOptions(SenderOptions options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    public long sendTimeout() {
        return this.sendTimeout;
    }

    public SenderOptions sendTimeout(long sendTimeout) {
        return this.sendTimeout(sendTimeout, TimeUnit.MILLISECONDS);
    }

    public SenderOptions sendTimeout(long timeout, TimeUnit units) {
        this.sendTimeout = units.toMillis(timeout);
        return this;
    }

    public SenderOptions clone() {
        return this.copyInto(new SenderOptions());
    }

    protected SenderOptions copyInto(SenderOptions other) {
        super.copyInto(other);
        other.sendTimeout(this.sendTimeout);
        other.deliveryTagGeneratorSupplier(this.tagGeneratorSupplier);
        return other;
    }

    public SenderOptions deliveryTagGeneratorSupplier(Supplier<DeliveryTagGenerator> supplier) {
        this.tagGeneratorSupplier = supplier;
        return this;
    }

    public Supplier<DeliveryTagGenerator> deliveryTagGeneratorSupplier() {
        return this.tagGeneratorSupplier;
    }

    @Override
    protected SenderOptions self() {
        return this;
    }
}

