/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.JsonSchemaValidator;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.Validator;

class PropertiesValidator
extends Validator<Map<String, Map>> {
    private Map<String, JsonSchemaValidator> jsonSchemas = new HashMap<String, JsonSchemaValidator>();
    private boolean additionalProperties;

    PropertiesValidator(Map schema, Map<String, Map> properties) {
        super(schema, properties);
        this.additionalProperties = schema.getOrDefault("additionalProperties", false);
        for (Map.Entry<String, Map> entry : properties.entrySet()) {
            this.jsonSchemas.put(entry.getKey(), new JsonSchemaValidator(entry.getValue()));
        }
    }

    @Override
    boolean validate(Object o, List<String> errs) {
        if (o instanceof Map) {
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                JsonSchemaValidator jsonSchema = this.jsonSchemas.get(key.toString());
                if (jsonSchema == null && !this.additionalProperties) {
                    errs.add("Unknown field '" + key + "' in object : " + Utils.toJSONString(o));
                    return false;
                }
                if (jsonSchema == null || jsonSchema.validate(entry.getValue(), errs)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

