// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.19.4
// source: service.proto

package v2

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Topics are destination of messages to publish to or subscribe from. Similar
// to domain names, they will be addressable after resolution through the
// provided access point.
//
// Access points are usually the addresses of name servers, which fulfill
// service discovery, load-balancing and other auxiliary services. Name servers
// receive periodic heartbeats from affiliate brokers and erase those which
// failed to maintain alive status.
//
// Name servers answer queries of QueryRouteRequest, responding clients with
// addressable message-queues, which they may directly publish messages to or
// subscribe messages from.
//
// QueryRouteRequest shall include source endpoints, aka, configured
// access-point, which annotates tenant-id, instance-id or other
// vendor-specific settings. Purpose-built name servers may respond customized
// results based on these particular requirements.
type QueryRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Topic     *Resource  `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	Endpoints *Endpoints `protobuf:"bytes,2,opt,name=endpoints,proto3" json:"endpoints,omitempty"`
}

func (x *QueryRouteRequest) Reset() {
	*x = QueryRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryRouteRequest) ProtoMessage() {}

func (x *QueryRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryRouteRequest.ProtoReflect.Descriptor instead.
func (*QueryRouteRequest) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{0}
}

func (x *QueryRouteRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *QueryRouteRequest) GetEndpoints() *Endpoints {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

type QueryRouteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status        *Status         `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	MessageQueues []*MessageQueue `protobuf:"bytes,2,rep,name=message_queues,json=messageQueues,proto3" json:"message_queues,omitempty"`
}

func (x *QueryRouteResponse) Reset() {
	*x = QueryRouteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryRouteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryRouteResponse) ProtoMessage() {}

func (x *QueryRouteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryRouteResponse.ProtoReflect.Descriptor instead.
func (*QueryRouteResponse) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{1}
}

func (x *QueryRouteResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *QueryRouteResponse) GetMessageQueues() []*MessageQueue {
	if x != nil {
		return x.MessageQueues
	}
	return nil
}

type SendMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Messages []*Message `protobuf:"bytes,1,rep,name=messages,proto3" json:"messages,omitempty"`
}

func (x *SendMessageRequest) Reset() {
	*x = SendMessageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendMessageRequest) ProtoMessage() {}

func (x *SendMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendMessageRequest.ProtoReflect.Descriptor instead.
func (*SendMessageRequest) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{2}
}

func (x *SendMessageRequest) GetMessages() []*Message {
	if x != nil {
		return x.Messages
	}
	return nil
}

type SendResultEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status        *Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	MessageId     string  `protobuf:"bytes,2,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	TransactionId string  `protobuf:"bytes,3,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Offset        int64   `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *SendResultEntry) Reset() {
	*x = SendResultEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendResultEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendResultEntry) ProtoMessage() {}

func (x *SendResultEntry) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendResultEntry.ProtoReflect.Descriptor instead.
func (*SendResultEntry) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{3}
}

func (x *SendResultEntry) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *SendResultEntry) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *SendResultEntry) GetTransactionId() string {
	if x != nil {
		return x.TransactionId
	}
	return ""
}

func (x *SendResultEntry) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

type SendMessageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status *Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Some implementation may have partial failure issues. Client SDK developers are expected to inspect
	// each entry for best certainty.
	Entries []*SendResultEntry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *SendMessageResponse) Reset() {
	*x = SendMessageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendMessageResponse) ProtoMessage() {}

func (x *SendMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendMessageResponse.ProtoReflect.Descriptor instead.
func (*SendMessageResponse) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{4}
}

func (x *SendMessageResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *SendMessageResponse) GetEntries() []*SendResultEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type QueryAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Topic     *Resource  `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	Group     *Resource  `protobuf:"bytes,2,opt,name=group,proto3" json:"group,omitempty"`
	Endpoints *Endpoints `protobuf:"bytes,3,opt,name=endpoints,proto3" json:"endpoints,omitempty"`
}

func (x *QueryAssignmentRequest) Reset() {
	*x = QueryAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryAssignmentRequest) ProtoMessage() {}

func (x *QueryAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryAssignmentRequest.ProtoReflect.Descriptor instead.
func (*QueryAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{5}
}

func (x *QueryAssignmentRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *QueryAssignmentRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *QueryAssignmentRequest) GetEndpoints() *Endpoints {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

type QueryAssignmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status      *Status       `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Assignments []*Assignment `protobuf:"bytes,2,rep,name=assignments,proto3" json:"assignments,omitempty"`
}

func (x *QueryAssignmentResponse) Reset() {
	*x = QueryAssignmentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryAssignmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryAssignmentResponse) ProtoMessage() {}

func (x *QueryAssignmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryAssignmentResponse.ProtoReflect.Descriptor instead.
func (*QueryAssignmentResponse) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{6}
}

func (x *QueryAssignmentResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *QueryAssignmentResponse) GetAssignments() []*Assignment {
	if x != nil {
		return x.Assignments
	}
	return nil
}

type ReceiveMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Group            *Resource         `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	MessageQueue     *MessageQueue     `protobuf:"bytes,2,opt,name=message_queue,json=messageQueue,proto3" json:"message_queue,omitempty"`
	FilterExpression *FilterExpression `protobuf:"bytes,3,opt,name=filter_expression,json=filterExpression,proto3" json:"filter_expression,omitempty"`
	BatchSize        int32             `protobuf:"varint,4,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	// Required if client type is simple consumer.
	InvisibleDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=invisible_duration,json=invisibleDuration,proto3,oneof" json:"invisible_duration,omitempty"`
	// For message auto renew and clean
	AutoRenew bool `protobuf:"varint,6,opt,name=auto_renew,json=autoRenew,proto3" json:"auto_renew,omitempty"`
}

func (x *ReceiveMessageRequest) Reset() {
	*x = ReceiveMessageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceiveMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceiveMessageRequest) ProtoMessage() {}

func (x *ReceiveMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceiveMessageRequest.ProtoReflect.Descriptor instead.
func (*ReceiveMessageRequest) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{7}
}

func (x *ReceiveMessageRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *ReceiveMessageRequest) GetMessageQueue() *MessageQueue {
	if x != nil {
		return x.MessageQueue
	}
	return nil
}

func (x *ReceiveMessageRequest) GetFilterExpression() *FilterExpression {
	if x != nil {
		return x.FilterExpression
	}
	return nil
}

func (x *ReceiveMessageRequest) GetBatchSize() int32 {
	if x != nil {
		return x.BatchSize
	}
	return 0
}

func (x *ReceiveMessageRequest) GetInvisibleDuration() *durationpb.Duration {
	if x != nil {
		return x.InvisibleDuration
	}
	return nil
}

func (x *ReceiveMessageRequest) GetAutoRenew() bool {
	if x != nil {
		return x.AutoRenew
	}
	return false
}

type ReceiveMessageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Content:
	//	*ReceiveMessageResponse_Status
	//	*ReceiveMessageResponse_Message
	//	*ReceiveMessageResponse_DeliveryTimestamp
	Content isReceiveMessageResponse_Content `protobuf_oneof:"content"`
}

func (x *ReceiveMessageResponse) Reset() {
	*x = ReceiveMessageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceiveMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceiveMessageResponse) ProtoMessage() {}

func (x *ReceiveMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceiveMessageResponse.ProtoReflect.Descriptor instead.
func (*ReceiveMessageResponse) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{8}
}

func (m *ReceiveMessageResponse) GetContent() isReceiveMessageResponse_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (x *ReceiveMessageResponse) GetStatus() *Status {
	if x, ok := x.GetContent().(*ReceiveMessageResponse_Status); ok {
		return x.Status
	}
	return nil
}

func (x *ReceiveMessageResponse) GetMessage() *Message {
	if x, ok := x.GetContent().(*ReceiveMessageResponse_Message); ok {
		return x.Message
	}
	return nil
}

func (x *ReceiveMessageResponse) GetDeliveryTimestamp() *timestamppb.Timestamp {
	if x, ok := x.GetContent().(*ReceiveMessageResponse_DeliveryTimestamp); ok {
		return x.DeliveryTimestamp
	}
	return nil
}

type isReceiveMessageResponse_Content interface {
	isReceiveMessageResponse_Content()
}

type ReceiveMessageResponse_Status struct {
	Status *Status `protobuf:"bytes,1,opt,name=status,proto3,oneof"`
}

type ReceiveMessageResponse_Message struct {
	Message *Message `protobuf:"bytes,2,opt,name=message,proto3,oneof"`
}

type ReceiveMessageResponse_DeliveryTimestamp struct {
	// The timestamp that brokers start to deliver status line or message.
	DeliveryTimestamp *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=delivery_timestamp,json=deliveryTimestamp,proto3,oneof"`
}

func (*ReceiveMessageResponse_Status) isReceiveMessageResponse_Content() {}

func (*ReceiveMessageResponse_Message) isReceiveMessageResponse_Content() {}

func (*ReceiveMessageResponse_DeliveryTimestamp) isReceiveMessageResponse_Content() {}

type AckMessageEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MessageId     string `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	ReceiptHandle string `protobuf:"bytes,2,opt,name=receipt_handle,json=receiptHandle,proto3" json:"receipt_handle,omitempty"`
}

func (x *AckMessageEntry) Reset() {
	*x = AckMessageEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AckMessageEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckMessageEntry) ProtoMessage() {}

func (x *AckMessageEntry) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckMessageEntry.ProtoReflect.Descriptor instead.
func (*AckMessageEntry) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{9}
}

func (x *AckMessageEntry) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *AckMessageEntry) GetReceiptHandle() string {
	if x != nil {
		return x.ReceiptHandle
	}
	return ""
}

type AckMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Group   *Resource          `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	Topic   *Resource          `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	Entries []*AckMessageEntry `protobuf:"bytes,3,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *AckMessageRequest) Reset() {
	*x = AckMessageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AckMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckMessageRequest) ProtoMessage() {}

func (x *AckMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckMessageRequest.ProtoReflect.Descriptor instead.
func (*AckMessageRequest) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{10}
}

func (x *AckMessageRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *AckMessageRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *AckMessageRequest) GetEntries() []*AckMessageEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type AckMessageResultEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MessageId     string `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	ReceiptHandle string `protobuf:"bytes,2,opt,name=receipt_handle,json=receiptHandle,proto3" json:"receipt_handle,omitempty"`
	// Acknowledge result may be acquired through inspecting
	// `status.code`; In case acknowledgement failed, `status.message`
	// is the explanation of the failure.
	Status *Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *AckMessageResultEntry) Reset() {
	*x = AckMessageResultEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AckMessageResultEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckMessageResultEntry) ProtoMessage() {}

func (x *AckMessageResultEntry) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckMessageResultEntry.ProtoReflect.Descriptor instead.
func (*AckMessageResultEntry) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{11}
}

func (x *AckMessageResultEntry) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *AckMessageResultEntry) GetReceiptHandle() string {
	if x != nil {
		return x.ReceiptHandle
	}
	return ""
}

func (x *AckMessageResultEntry) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type AckMessageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// RPC tier status, which is used to represent RPC-level errors including
	// authentication, authorization, throttling and other general failures.
	Status  *Status                  `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Entries []*AckMessageResultEntry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *AckMessageResponse) Reset() {
	*x = AckMessageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AckMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckMessageResponse) ProtoMessage() {}

func (x *AckMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckMessageResponse.ProtoReflect.Descriptor instead.
func (*AckMessageResponse) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{12}
}

func (x *AckMessageResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *AckMessageResponse) GetEntries() []*AckMessageResultEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type ForwardMessageToDeadLetterQueueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Group               *Resource `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	Topic               *Resource `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	ReceiptHandle       string    `protobuf:"bytes,3,opt,name=receipt_handle,json=receiptHandle,proto3" json:"receipt_handle,omitempty"`
	MessageId           string    `protobuf:"bytes,4,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	DeliveryAttempt     int32     `protobuf:"varint,5,opt,name=delivery_attempt,json=deliveryAttempt,proto3" json:"delivery_attempt,omitempty"`
	MaxDeliveryAttempts int32     `protobuf:"varint,6,opt,name=max_delivery_attempts,json=maxDeliveryAttempts,proto3" json:"max_delivery_attempts,omitempty"`
}

func (x *ForwardMessageToDeadLetterQueueRequest) Reset() {
	*x = ForwardMessageToDeadLetterQueueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardMessageToDeadLetterQueueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardMessageToDeadLetterQueueRequest) ProtoMessage() {}

func (x *ForwardMessageToDeadLetterQueueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardMessageToDeadLetterQueueRequest.ProtoReflect.Descriptor instead.
func (*ForwardMessageToDeadLetterQueueRequest) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{13}
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetReceiptHandle() string {
	if x != nil {
		return x.ReceiptHandle
	}
	return ""
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetDeliveryAttempt() int32 {
	if x != nil {
		return x.DeliveryAttempt
	}
	return 0
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetMaxDeliveryAttempts() int32 {
	if x != nil {
		return x.MaxDeliveryAttempts
	}
	return 0
}

type ForwardMessageToDeadLetterQueueResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status *Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *ForwardMessageToDeadLetterQueueResponse) Reset() {
	*x = ForwardMessageToDeadLetterQueueResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardMessageToDeadLetterQueueResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardMessageToDeadLetterQueueResponse) ProtoMessage() {}

func (x *ForwardMessageToDeadLetterQueueResponse) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardMessageToDeadLetterQueueResponse.ProtoReflect.Descriptor instead.
func (*ForwardMessageToDeadLetterQueueResponse) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{14}
}

func (x *ForwardMessageToDeadLetterQueueResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type HeartbeatRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Group      *Resource  `protobuf:"bytes,1,opt,name=group,proto3,oneof" json:"group,omitempty"`
	ClientType ClientType `protobuf:"varint,2,opt,name=client_type,json=clientType,proto3,enum=apache.rocketmq.v2.ClientType" json:"client_type,omitempty"`
}

func (x *HeartbeatRequest) Reset() {
	*x = HeartbeatRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartbeatRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartbeatRequest) ProtoMessage() {}

func (x *HeartbeatRequest) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartbeatRequest.ProtoReflect.Descriptor instead.
func (*HeartbeatRequest) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{15}
}

func (x *HeartbeatRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *HeartbeatRequest) GetClientType() ClientType {
	if x != nil {
		return x.ClientType
	}
	return ClientType_CLIENT_TYPE_UNSPECIFIED
}

type HeartbeatResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status *Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *HeartbeatResponse) Reset() {
	*x = HeartbeatResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartbeatResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartbeatResponse) ProtoMessage() {}

func (x *HeartbeatResponse) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartbeatResponse.ProtoReflect.Descriptor instead.
func (*HeartbeatResponse) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{16}
}

func (x *HeartbeatResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type EndTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Topic         *Resource             `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	MessageId     string                `protobuf:"bytes,2,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	TransactionId string                `protobuf:"bytes,3,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Resolution    TransactionResolution `protobuf:"varint,4,opt,name=resolution,proto3,enum=apache.rocketmq.v2.TransactionResolution" json:"resolution,omitempty"`
	Source        TransactionSource     `protobuf:"varint,5,opt,name=source,proto3,enum=apache.rocketmq.v2.TransactionSource" json:"source,omitempty"`
	TraceContext  string                `protobuf:"bytes,6,opt,name=trace_context,json=traceContext,proto3" json:"trace_context,omitempty"`
}

func (x *EndTransactionRequest) Reset() {
	*x = EndTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndTransactionRequest) ProtoMessage() {}

func (x *EndTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndTransactionRequest.ProtoReflect.Descriptor instead.
func (*EndTransactionRequest) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{17}
}

func (x *EndTransactionRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *EndTransactionRequest) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *EndTransactionRequest) GetTransactionId() string {
	if x != nil {
		return x.TransactionId
	}
	return ""
}

func (x *EndTransactionRequest) GetResolution() TransactionResolution {
	if x != nil {
		return x.Resolution
	}
	return TransactionResolution_TRANSACTION_RESOLUTION_UNSPECIFIED
}

func (x *EndTransactionRequest) GetSource() TransactionSource {
	if x != nil {
		return x.Source
	}
	return TransactionSource_SOURCE_UNSPECIFIED
}

func (x *EndTransactionRequest) GetTraceContext() string {
	if x != nil {
		return x.TraceContext
	}
	return ""
}

type EndTransactionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status *Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *EndTransactionResponse) Reset() {
	*x = EndTransactionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndTransactionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndTransactionResponse) ProtoMessage() {}

func (x *EndTransactionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndTransactionResponse.ProtoReflect.Descriptor instead.
func (*EndTransactionResponse) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{18}
}

func (x *EndTransactionResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type PrintThreadStackTraceCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nonce string `protobuf:"bytes,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
}

func (x *PrintThreadStackTraceCommand) Reset() {
	*x = PrintThreadStackTraceCommand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrintThreadStackTraceCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrintThreadStackTraceCommand) ProtoMessage() {}

func (x *PrintThreadStackTraceCommand) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrintThreadStackTraceCommand.ProtoReflect.Descriptor instead.
func (*PrintThreadStackTraceCommand) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{19}
}

func (x *PrintThreadStackTraceCommand) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

type ThreadStackTrace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nonce            string  `protobuf:"bytes,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	ThreadStackTrace *string `protobuf:"bytes,2,opt,name=thread_stack_trace,json=threadStackTrace,proto3,oneof" json:"thread_stack_trace,omitempty"`
}

func (x *ThreadStackTrace) Reset() {
	*x = ThreadStackTrace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ThreadStackTrace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ThreadStackTrace) ProtoMessage() {}

func (x *ThreadStackTrace) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ThreadStackTrace.ProtoReflect.Descriptor instead.
func (*ThreadStackTrace) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{20}
}

func (x *ThreadStackTrace) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

func (x *ThreadStackTrace) GetThreadStackTrace() string {
	if x != nil && x.ThreadStackTrace != nil {
		return *x.ThreadStackTrace
	}
	return ""
}

type VerifyMessageCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nonce   string   `protobuf:"bytes,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Message *Message `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *VerifyMessageCommand) Reset() {
	*x = VerifyMessageCommand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyMessageCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyMessageCommand) ProtoMessage() {}

func (x *VerifyMessageCommand) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyMessageCommand.ProtoReflect.Descriptor instead.
func (*VerifyMessageCommand) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{21}
}

func (x *VerifyMessageCommand) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

func (x *VerifyMessageCommand) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

type VerifyMessageResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nonce string `protobuf:"bytes,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
}

func (x *VerifyMessageResult) Reset() {
	*x = VerifyMessageResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyMessageResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyMessageResult) ProtoMessage() {}

func (x *VerifyMessageResult) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyMessageResult.ProtoReflect.Descriptor instead.
func (*VerifyMessageResult) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{22}
}

func (x *VerifyMessageResult) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

type RecoverOrphanedTransactionCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Message       *Message `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	TransactionId string   `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *RecoverOrphanedTransactionCommand) Reset() {
	*x = RecoverOrphanedTransactionCommand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecoverOrphanedTransactionCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecoverOrphanedTransactionCommand) ProtoMessage() {}

func (x *RecoverOrphanedTransactionCommand) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecoverOrphanedTransactionCommand.ProtoReflect.Descriptor instead.
func (*RecoverOrphanedTransactionCommand) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{23}
}

func (x *RecoverOrphanedTransactionCommand) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *RecoverOrphanedTransactionCommand) GetTransactionId() string {
	if x != nil {
		return x.TransactionId
	}
	return ""
}

type TelemetryCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status *Status `protobuf:"bytes,1,opt,name=status,proto3,oneof" json:"status,omitempty"`
	// Types that are assignable to Command:
	//	*TelemetryCommand_Settings
	//	*TelemetryCommand_ThreadStackTrace
	//	*TelemetryCommand_VerifyMessageResult
	//	*TelemetryCommand_RecoverOrphanedTransactionCommand
	//	*TelemetryCommand_PrintThreadStackTraceCommand
	//	*TelemetryCommand_VerifyMessageCommand
	Command isTelemetryCommand_Command `protobuf_oneof:"command"`
}

func (x *TelemetryCommand) Reset() {
	*x = TelemetryCommand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TelemetryCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryCommand) ProtoMessage() {}

func (x *TelemetryCommand) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryCommand.ProtoReflect.Descriptor instead.
func (*TelemetryCommand) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{24}
}

func (x *TelemetryCommand) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (m *TelemetryCommand) GetCommand() isTelemetryCommand_Command {
	if m != nil {
		return m.Command
	}
	return nil
}

func (x *TelemetryCommand) GetSettings() *Settings {
	if x, ok := x.GetCommand().(*TelemetryCommand_Settings); ok {
		return x.Settings
	}
	return nil
}

func (x *TelemetryCommand) GetThreadStackTrace() *ThreadStackTrace {
	if x, ok := x.GetCommand().(*TelemetryCommand_ThreadStackTrace); ok {
		return x.ThreadStackTrace
	}
	return nil
}

func (x *TelemetryCommand) GetVerifyMessageResult() *VerifyMessageResult {
	if x, ok := x.GetCommand().(*TelemetryCommand_VerifyMessageResult); ok {
		return x.VerifyMessageResult
	}
	return nil
}

func (x *TelemetryCommand) GetRecoverOrphanedTransactionCommand() *RecoverOrphanedTransactionCommand {
	if x, ok := x.GetCommand().(*TelemetryCommand_RecoverOrphanedTransactionCommand); ok {
		return x.RecoverOrphanedTransactionCommand
	}
	return nil
}

func (x *TelemetryCommand) GetPrintThreadStackTraceCommand() *PrintThreadStackTraceCommand {
	if x, ok := x.GetCommand().(*TelemetryCommand_PrintThreadStackTraceCommand); ok {
		return x.PrintThreadStackTraceCommand
	}
	return nil
}

func (x *TelemetryCommand) GetVerifyMessageCommand() *VerifyMessageCommand {
	if x, ok := x.GetCommand().(*TelemetryCommand_VerifyMessageCommand); ok {
		return x.VerifyMessageCommand
	}
	return nil
}

type isTelemetryCommand_Command interface {
	isTelemetryCommand_Command()
}

type TelemetryCommand_Settings struct {
	// Client settings
	Settings *Settings `protobuf:"bytes,2,opt,name=settings,proto3,oneof"`
}

type TelemetryCommand_ThreadStackTrace struct {
	// These messages are from client.
	//
	// Report thread stack trace to server.
	ThreadStackTrace *ThreadStackTrace `protobuf:"bytes,3,opt,name=thread_stack_trace,json=threadStackTrace,proto3,oneof"`
}

type TelemetryCommand_VerifyMessageResult struct {
	// Report message verify result to server.
	VerifyMessageResult *VerifyMessageResult `protobuf:"bytes,4,opt,name=verify_message_result,json=verifyMessageResult,proto3,oneof"`
}

type TelemetryCommand_RecoverOrphanedTransactionCommand struct {
	// There messages are from server.
	//
	// Request client to recover the orphaned transaction message.
	RecoverOrphanedTransactionCommand *RecoverOrphanedTransactionCommand `protobuf:"bytes,5,opt,name=recover_orphaned_transaction_command,json=recoverOrphanedTransactionCommand,proto3,oneof"`
}

type TelemetryCommand_PrintThreadStackTraceCommand struct {
	// Request client to print thread stack trace.
	PrintThreadStackTraceCommand *PrintThreadStackTraceCommand `protobuf:"bytes,6,opt,name=print_thread_stack_trace_command,json=printThreadStackTraceCommand,proto3,oneof"`
}

type TelemetryCommand_VerifyMessageCommand struct {
	// Request client to verify the consumption of the appointed message.
	VerifyMessageCommand *VerifyMessageCommand `protobuf:"bytes,7,opt,name=verify_message_command,json=verifyMessageCommand,proto3,oneof"`
}

func (*TelemetryCommand_Settings) isTelemetryCommand_Command() {}

func (*TelemetryCommand_ThreadStackTrace) isTelemetryCommand_Command() {}

func (*TelemetryCommand_VerifyMessageResult) isTelemetryCommand_Command() {}

func (*TelemetryCommand_RecoverOrphanedTransactionCommand) isTelemetryCommand_Command() {}

func (*TelemetryCommand_PrintThreadStackTraceCommand) isTelemetryCommand_Command() {}

func (*TelemetryCommand_VerifyMessageCommand) isTelemetryCommand_Command() {}

type NotifyClientTerminationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Consumer group, which is absent for producer.
	Group *Resource `protobuf:"bytes,1,opt,name=group,proto3,oneof" json:"group,omitempty"`
}

func (x *NotifyClientTerminationRequest) Reset() {
	*x = NotifyClientTerminationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotifyClientTerminationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotifyClientTerminationRequest) ProtoMessage() {}

func (x *NotifyClientTerminationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotifyClientTerminationRequest.ProtoReflect.Descriptor instead.
func (*NotifyClientTerminationRequest) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{25}
}

func (x *NotifyClientTerminationRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

type NotifyClientTerminationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status *Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *NotifyClientTerminationResponse) Reset() {
	*x = NotifyClientTerminationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotifyClientTerminationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotifyClientTerminationResponse) ProtoMessage() {}

func (x *NotifyClientTerminationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotifyClientTerminationResponse.ProtoReflect.Descriptor instead.
func (*NotifyClientTerminationResponse) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{26}
}

func (x *NotifyClientTerminationResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type ChangeInvisibleDurationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Group *Resource `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	Topic *Resource `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// Unique receipt handle to identify message to change
	ReceiptHandle string `protobuf:"bytes,3,opt,name=receipt_handle,json=receiptHandle,proto3" json:"receipt_handle,omitempty"`
	// New invisible duration
	InvisibleDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=invisible_duration,json=invisibleDuration,proto3" json:"invisible_duration,omitempty"`
	// For message tracing
	MessageId string `protobuf:"bytes,5,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
}

func (x *ChangeInvisibleDurationRequest) Reset() {
	*x = ChangeInvisibleDurationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeInvisibleDurationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeInvisibleDurationRequest) ProtoMessage() {}

func (x *ChangeInvisibleDurationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeInvisibleDurationRequest.ProtoReflect.Descriptor instead.
func (*ChangeInvisibleDurationRequest) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{27}
}

func (x *ChangeInvisibleDurationRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *ChangeInvisibleDurationRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *ChangeInvisibleDurationRequest) GetReceiptHandle() string {
	if x != nil {
		return x.ReceiptHandle
	}
	return ""
}

func (x *ChangeInvisibleDurationRequest) GetInvisibleDuration() *durationpb.Duration {
	if x != nil {
		return x.InvisibleDuration
	}
	return nil
}

func (x *ChangeInvisibleDurationRequest) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

type ChangeInvisibleDurationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status *Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Server may generate a new receipt handle for the message.
	ReceiptHandle string `protobuf:"bytes,2,opt,name=receipt_handle,json=receiptHandle,proto3" json:"receipt_handle,omitempty"`
}

func (x *ChangeInvisibleDurationResponse) Reset() {
	*x = ChangeInvisibleDurationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeInvisibleDurationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeInvisibleDurationResponse) ProtoMessage() {}

func (x *ChangeInvisibleDurationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeInvisibleDurationResponse.ProtoReflect.Descriptor instead.
func (*ChangeInvisibleDurationResponse) Descriptor() ([]byte, []int) {
	return file_service_proto_rawDescGZIP(), []int{28}
}

func (x *ChangeInvisibleDurationResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ChangeInvisibleDurationResponse) GetReceiptHandle() string {
	if x != nil {
		return x.ReceiptHandle
	}
	return ""
}

var File_service_proto protoreflect.FileDescriptor

var file_service_proto_rawDesc = []byte{
	0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x12, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71,
	0x2e, 0x76, 0x32, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x10, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x84, 0x01, 0x0a, 0x11, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x12, 0x3b, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22, 0x91, 0x01,
	0x0a, 0x12, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f,
	0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x47, 0x0a, 0x0e, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65,
	0x75, 0x65, 0x52, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65,
	0x73, 0x22, 0x4d, 0x0a, 0x12, 0x53, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x22, 0xa3, 0x01, 0x0a, 0x0f, 0x53, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x32, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f,
	0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x16,
	0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x88, 0x01, 0x0a, 0x13, 0x53, 0x65, 0x6e, 0x64, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x3d, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x22, 0xbd, 0x01, 0x0a, 0x16, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x12, 0x32, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d,
	0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x05, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x3b, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x22, 0x8f, 0x01, 0x0a, 0x17, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x40, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x22, 0x89, 0x03, 0x0a, 0x15, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x45, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x12, 0x51, 0x0a, 0x11, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x62, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x4d, 0x0a, 0x12, 0x69, 0x6e,
	0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x11, 0x69, 0x6e, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x75, 0x74,
	0x6f, 0x5f, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x61,
	0x75, 0x74, 0x6f, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x69, 0x6e, 0x76,
	0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xdf, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x37, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65,
	0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x48, 0x00,
	0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x4b, 0x0a, 0x12, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x48, 0x00, 0x52, 0x11, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x22, 0x57, 0x0a, 0x0f, 0x41, 0x63, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x5f, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x63,
	0x65, 0x69, 0x70, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x22, 0xba, 0x01, 0x0a, 0x11, 0x41,
	0x63, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x32, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d,
	0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x05, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x32, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x3d, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x63, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x91, 0x01, 0x0a, 0x15, 0x41, 0x63, 0x6b, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64,
	0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x63, 0x65, 0x69, 0x70,
	0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x32, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x8d, 0x01, 0x0a, 0x12,
	0x41, 0x63, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x32, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b,
	0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x43, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x6b,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xb5, 0x02, 0x0a, 0x26,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x44, 0x65, 0x61, 0x64, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x32, 0x0a, 0x05, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x25,
	0x0a, 0x0e, 0x72, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x48,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x12,
	0x32, 0x0a, 0x15, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f,
	0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13,
	0x6d, 0x61, 0x78, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x41, 0x74, 0x74, 0x65, 0x6d,
	0x70, 0x74, 0x73, 0x22, 0x5d, 0x0a, 0x27, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x44, 0x65, 0x61, 0x64, 0x4c, 0x65, 0x74, 0x74, 0x65,
	0x72, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x22, 0x96, 0x01, 0x0a, 0x10, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x88, 0x01, 0x01,
	0x12, 0x3f, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x47, 0x0a, 0x11, 0x48,
	0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x32, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x22, 0xc0, 0x02, 0x0a, 0x15, 0x45, 0x6e, 0x64, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32,
	0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x05, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49,
	0x64, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x49, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76,
	0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x4c, 0x0a, 0x16, 0x45, 0x6e, 0x64, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x32, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65,
	0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x34, 0x0a, 0x1c, 0x50, 0x72, 0x69, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x22, 0x72, 0x0a, 0x10, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x10, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b,
	0x54, 0x72, 0x61, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x22,
	0x63, 0x0a, 0x14, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x35, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71,
	0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x22, 0x2b, 0x0a, 0x13, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6e,
	0x6f, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63,
	0x65, 0x22, 0x81, 0x01, 0x0a, 0x21, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x4f, 0x72, 0x70,
	0x68, 0x61, 0x6e, 0x65, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x35, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x25,
	0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xbb, 0x05, 0x0a, 0x10, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x74, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x37, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x01, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x3a, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x54, 0x0a, 0x12, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x10, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b,
	0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x15, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f,
	0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52,
	0x13, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x88, 0x01, 0x0a, 0x24, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x5f, 0x6f, 0x72, 0x70, 0x68, 0x61, 0x6e, 0x65, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x4f, 0x72, 0x70, 0x68, 0x61, 0x6e, 0x65, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x21, 0x72, 0x65,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x4f, 0x72, 0x70, 0x68, 0x61, 0x6e, 0x65, 0x64, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12,
	0x7a, 0x0a, 0x20, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x50,
	0x72, 0x69, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54,
	0x72, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x1c, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54,
	0x72, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x60, 0x0a, 0x16, 0x76,
	0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32,
	0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x14, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x09, 0x0a,
	0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x22, 0x63, 0x0a, 0x1e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f,
	0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x48, 0x00, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x88, 0x01, 0x01, 0x42, 0x08,
	0x0a, 0x06, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x55, 0x0a, 0x1f, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22,
	0x98, 0x02, 0x0a, 0x1e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x49, 0x6e, 0x76, 0x69, 0x73, 0x69,
	0x62, 0x6c, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x32, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65,
	0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x32, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65,
	0x63, 0x65, 0x69, 0x70, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x12, 0x48, 0x0a, 0x12, 0x69, 0x6e, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x69, 0x6e, 0x76, 0x69, 0x73, 0x69,
	0x62, 0x6c, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x22, 0x7c, 0x0a, 0x1f, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x49, 0x6e, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x5f, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x63, 0x65, 0x69,
	0x70, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x32, 0xe0, 0x09, 0x0a, 0x10, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x5d, 0x0a,
	0x0a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x25, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32,
	0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b,
	0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5a, 0x0a, 0x09,
	0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x12, 0x24, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x48,
	0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x25, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d,
	0x71, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x60, 0x0a, 0x0b, 0x53, 0x65, 0x6e, 0x64,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x26, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x6e,
	0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x27, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d,
	0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x6c, 0x0a, 0x0f, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e,
	0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x6b, 0x0a, 0x0e, 0x52, 0x65, 0x63, 0x65,
	0x69, 0x76, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x29, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x5d, 0x0a, 0x0a, 0x41, 0x63, 0x6b, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x25, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x6b, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x63, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x9c, 0x01, 0x0a, 0x1f, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x44, 0x65, 0x61, 0x64, 0x4c, 0x65, 0x74,
	0x74, 0x65, 0x72, 0x51, 0x75, 0x65, 0x75, 0x65, 0x12, 0x3a, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x44, 0x65,
	0x61, 0x64, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f,
	0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x44, 0x65, 0x61, 0x64, 0x4c, 0x65,
	0x74, 0x74, 0x65, 0x72, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x69, 0x0a, 0x0e, 0x45, 0x6e, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x64, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2a, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5d,
	0x0a, 0x09, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x12, 0x24, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x1a, 0x24, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65,
	0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0x84, 0x01,
	0x0a, 0x17, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e,
	0x76, 0x32, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x84, 0x01, 0x0a, 0x17, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x49,
	0x6e, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x32, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x49, 0x6e, 0x76, 0x69,
	0x73, 0x69, 0x62, 0x6c, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f,
	0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x49, 0x6e, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x53, 0x0a, 0x12, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76,
	0x32, 0x42, 0x09, 0x4d, 0x51, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x01, 0x5a, 0x15,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e,
	0x76, 0x32, 0x3b, 0x76, 0x32, 0xa0, 0x01, 0x01, 0xd8, 0x01, 0x01, 0xaa, 0x02, 0x12, 0x41, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x52, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x56, 0x32,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_service_proto_rawDescOnce sync.Once
	file_service_proto_rawDescData = file_service_proto_rawDesc
)

func file_service_proto_rawDescGZIP() []byte {
	file_service_proto_rawDescOnce.Do(func() {
		file_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_service_proto_rawDescData)
	})
	return file_service_proto_rawDescData
}

var file_service_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_service_proto_goTypes = []interface{}{
	(*QueryRouteRequest)(nil),                       // 0: apache.rocketmq.v2.QueryRouteRequest
	(*QueryRouteResponse)(nil),                      // 1: apache.rocketmq.v2.QueryRouteResponse
	(*SendMessageRequest)(nil),                      // 2: apache.rocketmq.v2.SendMessageRequest
	(*SendResultEntry)(nil),                         // 3: apache.rocketmq.v2.SendResultEntry
	(*SendMessageResponse)(nil),                     // 4: apache.rocketmq.v2.SendMessageResponse
	(*QueryAssignmentRequest)(nil),                  // 5: apache.rocketmq.v2.QueryAssignmentRequest
	(*QueryAssignmentResponse)(nil),                 // 6: apache.rocketmq.v2.QueryAssignmentResponse
	(*ReceiveMessageRequest)(nil),                   // 7: apache.rocketmq.v2.ReceiveMessageRequest
	(*ReceiveMessageResponse)(nil),                  // 8: apache.rocketmq.v2.ReceiveMessageResponse
	(*AckMessageEntry)(nil),                         // 9: apache.rocketmq.v2.AckMessageEntry
	(*AckMessageRequest)(nil),                       // 10: apache.rocketmq.v2.AckMessageRequest
	(*AckMessageResultEntry)(nil),                   // 11: apache.rocketmq.v2.AckMessageResultEntry
	(*AckMessageResponse)(nil),                      // 12: apache.rocketmq.v2.AckMessageResponse
	(*ForwardMessageToDeadLetterQueueRequest)(nil),  // 13: apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest
	(*ForwardMessageToDeadLetterQueueResponse)(nil), // 14: apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse
	(*HeartbeatRequest)(nil),                        // 15: apache.rocketmq.v2.HeartbeatRequest
	(*HeartbeatResponse)(nil),                       // 16: apache.rocketmq.v2.HeartbeatResponse
	(*EndTransactionRequest)(nil),                   // 17: apache.rocketmq.v2.EndTransactionRequest
	(*EndTransactionResponse)(nil),                  // 18: apache.rocketmq.v2.EndTransactionResponse
	(*PrintThreadStackTraceCommand)(nil),            // 19: apache.rocketmq.v2.PrintThreadStackTraceCommand
	(*ThreadStackTrace)(nil),                        // 20: apache.rocketmq.v2.ThreadStackTrace
	(*VerifyMessageCommand)(nil),                    // 21: apache.rocketmq.v2.VerifyMessageCommand
	(*VerifyMessageResult)(nil),                     // 22: apache.rocketmq.v2.VerifyMessageResult
	(*RecoverOrphanedTransactionCommand)(nil),       // 23: apache.rocketmq.v2.RecoverOrphanedTransactionCommand
	(*TelemetryCommand)(nil),                        // 24: apache.rocketmq.v2.TelemetryCommand
	(*NotifyClientTerminationRequest)(nil),          // 25: apache.rocketmq.v2.NotifyClientTerminationRequest
	(*NotifyClientTerminationResponse)(nil),         // 26: apache.rocketmq.v2.NotifyClientTerminationResponse
	(*ChangeInvisibleDurationRequest)(nil),          // 27: apache.rocketmq.v2.ChangeInvisibleDurationRequest
	(*ChangeInvisibleDurationResponse)(nil),         // 28: apache.rocketmq.v2.ChangeInvisibleDurationResponse
	(*Resource)(nil),                                // 29: apache.rocketmq.v2.Resource
	(*Endpoints)(nil),                               // 30: apache.rocketmq.v2.Endpoints
	(*Status)(nil),                                  // 31: apache.rocketmq.v2.Status
	(*MessageQueue)(nil),                            // 32: apache.rocketmq.v2.MessageQueue
	(*Message)(nil),                                 // 33: apache.rocketmq.v2.Message
	(*Assignment)(nil),                              // 34: apache.rocketmq.v2.Assignment
	(*FilterExpression)(nil),                        // 35: apache.rocketmq.v2.FilterExpression
	(*durationpb.Duration)(nil),                     // 36: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                   // 37: google.protobuf.Timestamp
	(ClientType)(0),                                 // 38: apache.rocketmq.v2.ClientType
	(TransactionResolution)(0),                      // 39: apache.rocketmq.v2.TransactionResolution
	(TransactionSource)(0),                          // 40: apache.rocketmq.v2.TransactionSource
	(*Settings)(nil),                                // 41: apache.rocketmq.v2.Settings
}
var file_service_proto_depIdxs = []int32{
	29, // 0: apache.rocketmq.v2.QueryRouteRequest.topic:type_name -> apache.rocketmq.v2.Resource
	30, // 1: apache.rocketmq.v2.QueryRouteRequest.endpoints:type_name -> apache.rocketmq.v2.Endpoints
	31, // 2: apache.rocketmq.v2.QueryRouteResponse.status:type_name -> apache.rocketmq.v2.Status
	32, // 3: apache.rocketmq.v2.QueryRouteResponse.message_queues:type_name -> apache.rocketmq.v2.MessageQueue
	33, // 4: apache.rocketmq.v2.SendMessageRequest.messages:type_name -> apache.rocketmq.v2.Message
	31, // 5: apache.rocketmq.v2.SendResultEntry.status:type_name -> apache.rocketmq.v2.Status
	31, // 6: apache.rocketmq.v2.SendMessageResponse.status:type_name -> apache.rocketmq.v2.Status
	3,  // 7: apache.rocketmq.v2.SendMessageResponse.entries:type_name -> apache.rocketmq.v2.SendResultEntry
	29, // 8: apache.rocketmq.v2.QueryAssignmentRequest.topic:type_name -> apache.rocketmq.v2.Resource
	29, // 9: apache.rocketmq.v2.QueryAssignmentRequest.group:type_name -> apache.rocketmq.v2.Resource
	30, // 10: apache.rocketmq.v2.QueryAssignmentRequest.endpoints:type_name -> apache.rocketmq.v2.Endpoints
	31, // 11: apache.rocketmq.v2.QueryAssignmentResponse.status:type_name -> apache.rocketmq.v2.Status
	34, // 12: apache.rocketmq.v2.QueryAssignmentResponse.assignments:type_name -> apache.rocketmq.v2.Assignment
	29, // 13: apache.rocketmq.v2.ReceiveMessageRequest.group:type_name -> apache.rocketmq.v2.Resource
	32, // 14: apache.rocketmq.v2.ReceiveMessageRequest.message_queue:type_name -> apache.rocketmq.v2.MessageQueue
	35, // 15: apache.rocketmq.v2.ReceiveMessageRequest.filter_expression:type_name -> apache.rocketmq.v2.FilterExpression
	36, // 16: apache.rocketmq.v2.ReceiveMessageRequest.invisible_duration:type_name -> google.protobuf.Duration
	31, // 17: apache.rocketmq.v2.ReceiveMessageResponse.status:type_name -> apache.rocketmq.v2.Status
	33, // 18: apache.rocketmq.v2.ReceiveMessageResponse.message:type_name -> apache.rocketmq.v2.Message
	37, // 19: apache.rocketmq.v2.ReceiveMessageResponse.delivery_timestamp:type_name -> google.protobuf.Timestamp
	29, // 20: apache.rocketmq.v2.AckMessageRequest.group:type_name -> apache.rocketmq.v2.Resource
	29, // 21: apache.rocketmq.v2.AckMessageRequest.topic:type_name -> apache.rocketmq.v2.Resource
	9,  // 22: apache.rocketmq.v2.AckMessageRequest.entries:type_name -> apache.rocketmq.v2.AckMessageEntry
	31, // 23: apache.rocketmq.v2.AckMessageResultEntry.status:type_name -> apache.rocketmq.v2.Status
	31, // 24: apache.rocketmq.v2.AckMessageResponse.status:type_name -> apache.rocketmq.v2.Status
	11, // 25: apache.rocketmq.v2.AckMessageResponse.entries:type_name -> apache.rocketmq.v2.AckMessageResultEntry
	29, // 26: apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest.group:type_name -> apache.rocketmq.v2.Resource
	29, // 27: apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest.topic:type_name -> apache.rocketmq.v2.Resource
	31, // 28: apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse.status:type_name -> apache.rocketmq.v2.Status
	29, // 29: apache.rocketmq.v2.HeartbeatRequest.group:type_name -> apache.rocketmq.v2.Resource
	38, // 30: apache.rocketmq.v2.HeartbeatRequest.client_type:type_name -> apache.rocketmq.v2.ClientType
	31, // 31: apache.rocketmq.v2.HeartbeatResponse.status:type_name -> apache.rocketmq.v2.Status
	29, // 32: apache.rocketmq.v2.EndTransactionRequest.topic:type_name -> apache.rocketmq.v2.Resource
	39, // 33: apache.rocketmq.v2.EndTransactionRequest.resolution:type_name -> apache.rocketmq.v2.TransactionResolution
	40, // 34: apache.rocketmq.v2.EndTransactionRequest.source:type_name -> apache.rocketmq.v2.TransactionSource
	31, // 35: apache.rocketmq.v2.EndTransactionResponse.status:type_name -> apache.rocketmq.v2.Status
	33, // 36: apache.rocketmq.v2.VerifyMessageCommand.message:type_name -> apache.rocketmq.v2.Message
	33, // 37: apache.rocketmq.v2.RecoverOrphanedTransactionCommand.message:type_name -> apache.rocketmq.v2.Message
	31, // 38: apache.rocketmq.v2.TelemetryCommand.status:type_name -> apache.rocketmq.v2.Status
	41, // 39: apache.rocketmq.v2.TelemetryCommand.settings:type_name -> apache.rocketmq.v2.Settings
	20, // 40: apache.rocketmq.v2.TelemetryCommand.thread_stack_trace:type_name -> apache.rocketmq.v2.ThreadStackTrace
	22, // 41: apache.rocketmq.v2.TelemetryCommand.verify_message_result:type_name -> apache.rocketmq.v2.VerifyMessageResult
	23, // 42: apache.rocketmq.v2.TelemetryCommand.recover_orphaned_transaction_command:type_name -> apache.rocketmq.v2.RecoverOrphanedTransactionCommand
	19, // 43: apache.rocketmq.v2.TelemetryCommand.print_thread_stack_trace_command:type_name -> apache.rocketmq.v2.PrintThreadStackTraceCommand
	21, // 44: apache.rocketmq.v2.TelemetryCommand.verify_message_command:type_name -> apache.rocketmq.v2.VerifyMessageCommand
	29, // 45: apache.rocketmq.v2.NotifyClientTerminationRequest.group:type_name -> apache.rocketmq.v2.Resource
	31, // 46: apache.rocketmq.v2.NotifyClientTerminationResponse.status:type_name -> apache.rocketmq.v2.Status
	29, // 47: apache.rocketmq.v2.ChangeInvisibleDurationRequest.group:type_name -> apache.rocketmq.v2.Resource
	29, // 48: apache.rocketmq.v2.ChangeInvisibleDurationRequest.topic:type_name -> apache.rocketmq.v2.Resource
	36, // 49: apache.rocketmq.v2.ChangeInvisibleDurationRequest.invisible_duration:type_name -> google.protobuf.Duration
	31, // 50: apache.rocketmq.v2.ChangeInvisibleDurationResponse.status:type_name -> apache.rocketmq.v2.Status
	0,  // 51: apache.rocketmq.v2.MessagingService.QueryRoute:input_type -> apache.rocketmq.v2.QueryRouteRequest
	15, // 52: apache.rocketmq.v2.MessagingService.Heartbeat:input_type -> apache.rocketmq.v2.HeartbeatRequest
	2,  // 53: apache.rocketmq.v2.MessagingService.SendMessage:input_type -> apache.rocketmq.v2.SendMessageRequest
	5,  // 54: apache.rocketmq.v2.MessagingService.QueryAssignment:input_type -> apache.rocketmq.v2.QueryAssignmentRequest
	7,  // 55: apache.rocketmq.v2.MessagingService.ReceiveMessage:input_type -> apache.rocketmq.v2.ReceiveMessageRequest
	10, // 56: apache.rocketmq.v2.MessagingService.AckMessage:input_type -> apache.rocketmq.v2.AckMessageRequest
	13, // 57: apache.rocketmq.v2.MessagingService.ForwardMessageToDeadLetterQueue:input_type -> apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest
	17, // 58: apache.rocketmq.v2.MessagingService.EndTransaction:input_type -> apache.rocketmq.v2.EndTransactionRequest
	24, // 59: apache.rocketmq.v2.MessagingService.Telemetry:input_type -> apache.rocketmq.v2.TelemetryCommand
	25, // 60: apache.rocketmq.v2.MessagingService.NotifyClientTermination:input_type -> apache.rocketmq.v2.NotifyClientTerminationRequest
	27, // 61: apache.rocketmq.v2.MessagingService.ChangeInvisibleDuration:input_type -> apache.rocketmq.v2.ChangeInvisibleDurationRequest
	1,  // 62: apache.rocketmq.v2.MessagingService.QueryRoute:output_type -> apache.rocketmq.v2.QueryRouteResponse
	16, // 63: apache.rocketmq.v2.MessagingService.Heartbeat:output_type -> apache.rocketmq.v2.HeartbeatResponse
	4,  // 64: apache.rocketmq.v2.MessagingService.SendMessage:output_type -> apache.rocketmq.v2.SendMessageResponse
	6,  // 65: apache.rocketmq.v2.MessagingService.QueryAssignment:output_type -> apache.rocketmq.v2.QueryAssignmentResponse
	8,  // 66: apache.rocketmq.v2.MessagingService.ReceiveMessage:output_type -> apache.rocketmq.v2.ReceiveMessageResponse
	12, // 67: apache.rocketmq.v2.MessagingService.AckMessage:output_type -> apache.rocketmq.v2.AckMessageResponse
	14, // 68: apache.rocketmq.v2.MessagingService.ForwardMessageToDeadLetterQueue:output_type -> apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse
	18, // 69: apache.rocketmq.v2.MessagingService.EndTransaction:output_type -> apache.rocketmq.v2.EndTransactionResponse
	24, // 70: apache.rocketmq.v2.MessagingService.Telemetry:output_type -> apache.rocketmq.v2.TelemetryCommand
	26, // 71: apache.rocketmq.v2.MessagingService.NotifyClientTermination:output_type -> apache.rocketmq.v2.NotifyClientTerminationResponse
	28, // 72: apache.rocketmq.v2.MessagingService.ChangeInvisibleDuration:output_type -> apache.rocketmq.v2.ChangeInvisibleDurationResponse
	62, // [62:73] is the sub-list for method output_type
	51, // [51:62] is the sub-list for method input_type
	51, // [51:51] is the sub-list for extension type_name
	51, // [51:51] is the sub-list for extension extendee
	0,  // [0:51] is the sub-list for field type_name
}

func init() { file_service_proto_init() }
func file_service_proto_init() {
	if File_service_proto != nil {
		return
	}
	file_definition_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryRouteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendMessageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendResultEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendMessageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryAssignmentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceiveMessageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceiveMessageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AckMessageEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AckMessageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AckMessageResultEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AckMessageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForwardMessageToDeadLetterQueueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForwardMessageToDeadLetterQueueResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartbeatRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartbeatResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndTransactionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrintThreadStackTraceCommand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ThreadStackTrace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyMessageCommand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyMessageResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecoverOrphanedTransactionCommand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TelemetryCommand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotifyClientTerminationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotifyClientTerminationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeInvisibleDurationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeInvisibleDurationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_service_proto_msgTypes[7].OneofWrappers = []interface{}{}
	file_service_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*ReceiveMessageResponse_Status)(nil),
		(*ReceiveMessageResponse_Message)(nil),
		(*ReceiveMessageResponse_DeliveryTimestamp)(nil),
	}
	file_service_proto_msgTypes[15].OneofWrappers = []interface{}{}
	file_service_proto_msgTypes[20].OneofWrappers = []interface{}{}
	file_service_proto_msgTypes[24].OneofWrappers = []interface{}{
		(*TelemetryCommand_Settings)(nil),
		(*TelemetryCommand_ThreadStackTrace)(nil),
		(*TelemetryCommand_VerifyMessageResult)(nil),
		(*TelemetryCommand_RecoverOrphanedTransactionCommand)(nil),
		(*TelemetryCommand_PrintThreadStackTraceCommand)(nil),
		(*TelemetryCommand_VerifyMessageCommand)(nil),
	}
	file_service_proto_msgTypes[25].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_service_proto_goTypes,
		DependencyIndexes: file_service_proto_depIdxs,
		MessageInfos:      file_service_proto_msgTypes,
	}.Build()
	File_service_proto = out.File
	file_service_proto_rawDesc = nil
	file_service_proto_goTypes = nil
	file_service_proto_depIdxs = nil
}
