/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl;

import apache.rocketmq.v2.PrintThreadStackTraceCommand;
import apache.rocketmq.v2.RecoverOrphanedTransactionCommand;
import apache.rocketmq.v2.Settings;
import apache.rocketmq.v2.TelemetryCommand;
import apache.rocketmq.v2.VerifyMessageCommand;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.java.impl.producer.ClientSessionHandler;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSessionImpl
implements StreamObserver<TelemetryCommand> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientSessionImpl.class);
    private static final Duration REQUEST_OBSERVER_RENEW_BACKOFF_DELAY = Duration.ofSeconds(1L);
    private final ClientSessionHandler sessionHandler;
    private final Endpoints endpoints;
    private volatile StreamObserver<TelemetryCommand> requestObserver;

    protected ClientSessionImpl(ClientSessionHandler sessionHandler, Endpoints endpoints) throws ClientException {
        this.sessionHandler = sessionHandler;
        this.endpoints = endpoints;
        this.requestObserver = sessionHandler.telemetry(endpoints, this);
    }

    private void renewRequestObserver() {
        try {
            if (this.sessionHandler.isEndpointsDeprecated(this.endpoints)) {
                LOGGER.info("Endpoints is deprecated, no longer to renew requestObserver, endpoints={}", (Object)this.endpoints);
                return;
            }
            this.requestObserver = this.sessionHandler.telemetry(this.endpoints, this);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to renew requestObserver, attempt to renew later, endpoints={}, delay={}", new Object[]{this.endpoints, REQUEST_OBSERVER_RENEW_BACKOFF_DELAY, t});
            this.sessionHandler.getScheduler().schedule(this::renewRequestObserver, REQUEST_OBSERVER_RENEW_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
            return;
        }
        this.syncSettings();
    }

    protected ListenableFuture<Void> syncSettingsSafely() {
        try {
            this.syncSettings();
            return this.sessionHandler.awaitSettingSynchronized();
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    private void syncSettings() {
        TelemetryCommand settings = this.sessionHandler.settingsCommand();
        this.fireWrite(settings);
    }

    public void release() {
        if (null == this.requestObserver) {
            return;
        }
        try {
            this.requestObserver.onCompleted();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void fireWrite(TelemetryCommand command) {
        if (null == this.requestObserver) {
            LOGGER.error("Request observer does not exist, ignore current command, endpoints={}, command={}", (Object)this.endpoints, (Object)command);
            return;
        }
        this.requestObserver.onNext((Object)command);
    }

    public void onNext(TelemetryCommand command) {
        String clientId = this.sessionHandler.clientId();
        try {
            switch (command.getCommandCase()) {
                case SETTINGS: {
                    Settings settings = command.getSettings();
                    LOGGER.info("Receive settings from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onSettingsCommand(this.endpoints, settings);
                    break;
                }
                case RECOVER_ORPHANED_TRANSACTION_COMMAND: {
                    RecoverOrphanedTransactionCommand recoverOrphanedTransactionCommand = command.getRecoverOrphanedTransactionCommand();
                    LOGGER.info("Receive orphaned transaction recovery command from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onRecoverOrphanedTransactionCommand(this.endpoints, recoverOrphanedTransactionCommand);
                    break;
                }
                case VERIFY_MESSAGE_COMMAND: {
                    VerifyMessageCommand verifyMessageCommand = command.getVerifyMessageCommand();
                    LOGGER.info("Receive message verification command from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onVerifyMessageCommand(this.endpoints, verifyMessageCommand);
                    break;
                }
                case PRINT_THREAD_STACK_TRACE_COMMAND: {
                    PrintThreadStackTraceCommand printThreadStackTraceCommand = command.getPrintThreadStackTraceCommand();
                    LOGGER.info("Receive thread stack print command from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onPrintThreadStackTraceCommand(this.endpoints, printThreadStackTraceCommand);
                    break;
                }
                default: {
                    LOGGER.warn("Receive unrecognized command from remote, endpoints={}, command={}, clientId={}", new Object[]{this.endpoints, command, clientId});
                    break;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("[Bug] unexpected exception raised while receiving command from remote, command={}, clientId={}", new Object[]{command, clientId, t});
        }
    }

    public void onError(Throwable throwable) {
        LOGGER.error("Exception raised from stream response observer, clientId={}, endpoints={}", new Object[]{this.sessionHandler.clientId(), this.endpoints, throwable});
        this.release();
        if (!this.sessionHandler.isRunning()) {
            return;
        }
        this.sessionHandler.getScheduler().schedule(this::renewRequestObserver, 3L, TimeUnit.SECONDS);
    }

    public void onCompleted() {
        this.release();
        if (!this.sessionHandler.isRunning()) {
            return;
        }
        this.sessionHandler.getScheduler().schedule(this::renewRequestObserver, 3L, TimeUnit.SECONDS);
    }
}

