/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.retry;

import apache.rocketmq.v2.CustomizedBackoff;
import apache.rocketmq.v2.RetryPolicy;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.java.retry.RetryPolicy;

public class CustomizedBackoffRetryPolicy
implements RetryPolicy {
    private final List<java.time.Duration> durations;
    private final int maxAttempts;

    public CustomizedBackoffRetryPolicy(List<java.time.Duration> durations, int maxAttempts) {
        Preconditions.checkArgument((!durations.isEmpty() ? 1 : 0) != 0, (Object)"durations must not be empty");
        this.durations = durations;
        this.maxAttempts = maxAttempts;
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public java.time.Duration getNextAttemptDelay(int attempt) {
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt must be positive");
        return attempt > this.durations.size() ? this.durations.get(this.durations.size() - 1) : this.durations.get(attempt - 1);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("durations", this.durations).add("maxAttempts", this.maxAttempts).toString();
    }

    public static CustomizedBackoffRetryPolicy fromProtobuf(apache.rocketmq.v2.RetryPolicy retryPolicy) {
        if (!RetryPolicy.StrategyCase.CUSTOMIZED_BACKOFF.equals((Object)retryPolicy.getStrategyCase())) {
            throw new IllegalArgumentException();
        }
        CustomizedBackoff customizedBackoff = retryPolicy.getCustomizedBackoff();
        List<java.time.Duration> durations = customizedBackoff.getNextList().stream().map(duration -> java.time.Duration.ofNanos(Durations.toNanos((Duration)duration))).collect(Collectors.toList());
        return new CustomizedBackoffRetryPolicy(durations, retryPolicy.getMaxAttempts());
    }

    @Override
    public RetryPolicy updateBackoff(apache.rocketmq.v2.RetryPolicy retryPolicy) {
        if (!RetryPolicy.StrategyCase.CUSTOMIZED_BACKOFF.equals((Object)retryPolicy.getStrategyCase())) {
            throw new IllegalArgumentException("strategy must be customized backoff");
        }
        return this.updateBackoff(retryPolicy.getCustomizedBackoff());
    }

    private RetryPolicy updateBackoff(CustomizedBackoff backoff) {
        List<java.time.Duration> durations = backoff.getNextList().stream().map(duration -> java.time.Duration.ofNanos(Durations.toNanos((Duration)duration))).collect(Collectors.toList());
        return new CustomizedBackoffRetryPolicy(durations, this.maxAttempts);
    }

    @Override
    public apache.rocketmq.v2.RetryPolicy toProtobuf() {
        CustomizedBackoff customizedBackoff = CustomizedBackoff.newBuilder().addAllNext((Iterable)this.durations.stream().map(duration -> Durations.fromNanos((long)duration.toNanos())).collect(Collectors.toList())).build();
        return apache.rocketmq.v2.RetryPolicy.newBuilder().setMaxAttempts(this.maxAttempts).setCustomizedBackoff(customizedBackoff).build();
    }
}

