/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.rpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements ClientInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingInterceptor.class);
    private static final LoggingInterceptor INSTANCE = new LoggingInterceptor();

    public static LoggingInterceptor getInstance() {
        return INSTANCE;
    }

    public <T, E> ClientCall<T, E> interceptCall(MethodDescriptor<T, E> method, CallOptions callOptions, Channel next) {
        final String rpcId = UUID.randomUUID().toString();
        final String authority = next.authority();
        final String serviceName = method.getServiceName();
        final String methodName = method.getBareMethodName();
        return new ForwardingClientCall.SimpleForwardingClientCall<T, E>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<E> responseListener, Metadata headers) {
                LOGGER.trace("gRPC request header, rpcId={}, serviceName={}, methodName={}, authority={}, headers={}", new Object[]{rpcId, serviceName, methodName, authority, headers});
                ForwardingClientCallListener.SimpleForwardingClientCallListener observabilityListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<E>(responseListener){

                    public void onMessage(E response) {
                        LOGGER.trace("gRPC response, rpcId={}, serviceName={}, methodName={}, content:\n{}", new Object[]{rpcId, serviceName, methodName, response});
                        super.onMessage(response);
                    }

                    public void onHeaders(Metadata headers) {
                        LOGGER.trace("gRPC response header, rpcId={}, serviceName={}, methodName={}, authority={}, headers={}", new Object[]{rpcId, serviceName, methodName, authority, headers});
                        super.onHeaders(headers);
                    }
                };
                super.start((ClientCall.Listener)observabilityListener, headers);
            }

            public void sendMessage(T request) {
                LOGGER.trace("gRPC request, rpcId={}, serviceName={}, methodName={}, content:\n{}", new Object[]{rpcId, serviceName, methodName, request});
                super.sendMessage(request);
            }
        };
    }
}

