/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.rpc;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.rocketmq.client.java.misc.Utilities;

public class TLSHelper {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    private TLSHelper() {
    }

    public static String sign(String accessSecret, String dateTime) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec signingKey = new SecretKeySpec(accessSecret.getBytes(StandardCharsets.UTF_8), HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(signingKey);
        return Utilities.encodeHexString(mac.doFinal(dateTime.getBytes(StandardCharsets.UTF_8)), false);
    }
}

