/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.example;

import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.apache.rocketmq.client.apis.producer.Transaction;
import org.apache.rocketmq.client.apis.producer.TransactionChecker;
import org.apache.rocketmq.client.apis.producer.TransactionResolution;
import org.apache.rocketmq.client.java.example.ProducerSingleton;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class ProducerTransactionMessageExample {
    private static final Logger log = LoggerFactory.getLogger(ProducerTransactionMessageExample.class);

    private ProducerTransactionMessageExample() {
    }

    public static void main(String[] args) throws ClientException {
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        String topic = "yourTransactionTopic";
        TransactionChecker checker = messageView -> {
            log.info("Receive transactional message check, message={}", (Object)messageView);
            return TransactionResolution.COMMIT;
        };
        Producer producer = ProducerSingleton.getTransactionalInstance(checker, topic);
        Transaction transaction = producer.beginTransaction();
        byte[] body = "This is a transaction message for Apache RocketMQ".getBytes(StandardCharsets.UTF_8);
        String tag = "yourMessageTagA";
        Message message = provider.newMessageBuilder().setTopic(topic).setTag(tag).setKeys("yourMessageKey-565ef26f5727").setBody(body).build();
        try {
            SendReceipt sendReceipt = producer.send(message, transaction);
            log.info("Send transaction message successfully, messageId={}", (Object)sendReceipt.getMessageId());
        }
        catch (Throwable t2) {
            log.error("Failed to send message", t2);
            return;
        }
        transaction.commit();
    }
}

