/*!
 * AngularJS Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.2.4-master-bfc8ae7
 */
function MdChipCtrl(t,e,i,n,s){this.$scope=t,this.$element=e,this.$mdConstant=i,this.$timeout=n,this.$mdUtil=s,this.isEditing=!1,this.parentController=void 0,this.enableChipEdit=!1}function MdChip(p,t,e,a){return{restrict:"E",require:["^?mdChips","mdChip"],link:function(t,e,i,n){var s=n.shift(),r=n.shift(),o=angular.element(e[0].querySelector(".md-chip-content"));p(e),s&&(r.init(s),o.on("blur",function(){s.resetSelectedChip(),s.$scope.$applyAsync()}));a(function(){s&&s.shouldFocusLastChip&&s.focusLastChipThenInput()})},controller:"MdChipCtrl"}}function MdChipRemove(s){return{restrict:"A",require:"^mdChips",scope:!1,link:function(t,e,i,n){e.on("click",function(){t.$apply(function(){n.removeChip(t.$$replacedScope.$index)})}),s(function(){e.attr({tabindex:"-1","aria-hidden":"true"}),e.find("button").attr("tabindex","-1")})}}}function MdChipTransclude(o){return{restrict:"EA",terminal:!0,link:function(t,e,i){var n=t.$parent.$mdChipsCtrl,s=n.parent.$new(!1,n.parent);s.$$replacedScope=t,s.$chip=t.$chip,s.$index=t.$index;var r=(s.$mdChipsCtrl=n).$scope.$eval(i.mdChipTransclude);e.html(r),o(e.contents())(s)},scope:!1}}goog.provide("ngmaterial.components.chips"),goog.require("ngmaterial.components.autocomplete"),goog.require("ngmaterial.core"),angular.module("material.components.chips",["material.core","material.components.autocomplete"]),MdChipCtrl.$inject=["$scope","$element","$mdConstant","$timeout","$mdUtil"],angular.module("material.components.chips").controller("MdChipCtrl",MdChipCtrl),MdChipCtrl.prototype.init=function(t){this.parentController=t,this.enableChipEdit=this.parentController.enableChipEdit,this.enableChipEdit&&(this.$element.on("keydown",this.chipKeyDown.bind(this)),this.$element.on("dblclick",this.chipMouseDoubleClick.bind(this)),this.getChipContent().addClass("_md-chip-content-edit-is-enabled"))},MdChipCtrl.prototype.getChipContent=function(){var t=this.$element[0].getElementsByClassName("md-chip-content");return angular.element(t[0])},MdChipCtrl.prototype.getContentElement=function(){var t=angular.element(this.getChipContent().children()[0]);return t&&0!==t.length||(t=angular.element(this.getChipContent().contents()[0])),t},MdChipCtrl.prototype.getChipIndex=function(){return parseInt(this.$element.attr("index"))},MdChipCtrl.prototype.goOutOfEditMode=function(){if(this.isEditing){this.isEditing=!1,this.$element.removeClass("_md-chip-editing"),this.getChipContent()[0].contentEditable="false";var t=this.getChipIndex(),e=this.getContentElement().text();e?(this.parentController.updateChipContents(t,e),this.$mdUtil.nextTick(function(){this.parentController.selectedChip===t&&this.parentController.focusChip(t)}.bind(this))):this.parentController.removeChipAndFocusInput(t)}},MdChipCtrl.prototype.selectNodeContents=function(t){var e,i;document.body.createTextRange?((e=document.body.createTextRange()).moveToElementText(t),e.select()):window.getSelection&&(i=window.getSelection(),(e=document.createRange()).selectNodeContents(t),i.removeAllRanges(),i.addRange(e))},MdChipCtrl.prototype.goInEditMode=function(){this.isEditing=!0,this.$element.addClass("_md-chip-editing"),this.getChipContent()[0].contentEditable="true",this.getChipContent().on("blur",function(){this.goOutOfEditMode()}.bind(this)),this.selectNodeContents(this.getChipContent()[0])},MdChipCtrl.prototype.chipKeyDown=function(t){this.isEditing||t.keyCode!==this.$mdConstant.KEY_CODE.ENTER&&t.keyCode!==this.$mdConstant.KEY_CODE.SPACE?this.isEditing&&t.keyCode===this.$mdConstant.KEY_CODE.ENTER&&(t.preventDefault(),this.goOutOfEditMode()):(t.preventDefault(),this.goInEditMode())},MdChipCtrl.prototype.chipMouseDoubleClick=function(){this.enableChipEdit&&!this.isEditing&&this.goInEditMode()},MdChip.$inject=["$mdTheming","$mdUtil","$compile","$timeout"],angular.module("material.components.chips").directive("mdChip",MdChip),MdChipRemove.$inject=["$timeout"],angular.module("material.components.chips").directive("mdChipRemove",MdChipRemove),MdChipTransclude.$inject=["$compile"],angular.module("material.components.chips").directive("mdChipTransclude",MdChipTransclude),MdChipsCtrl.$inject=["$scope","$attrs","$mdConstant","$log","$element","$timeout","$mdUtil","$mdLiveAnnouncer","$exceptionHandler"];var DEFAULT_CHIP_APPEND_DELAY=300;function MdChipsCtrl(t,e,i,n,s,r,o,p,a){this.$timeout=r,this.$mdConstant=i,this.$scope=t,this.parent=t.$parent,this.$mdUtil=o,this.$log=n,this.$mdLiveAnnouncer=p,this.$exceptionHandler=a,this.$element=s,this.$attrs=e,this.ngModelCtrl=null,this.userInputNgModelCtrl=null,this.autocompleteCtrl=null,this.userInputElement=null,this.items=[],this.selectedChip=-1,this.enableChipEdit=o.parseAttributeBoolean(e.mdEnableChipEdit),this.addOnBlur=o.parseAttributeBoolean(e.mdAddOnBlur),this.inputClass="",this.inputAriaLabel="Chips input.",this.containerHint="Chips container. Use arrow keys to select chips.",this.containerEmptyHint="Chips container. Enter the text area, then type text, and press enter to add a chip.",this.deleteHint="Press delete to remove this chip.",this.deleteButtonLabel="Remove",this.chipBuffer="",this.useTransformChip=!1,this.useOnAdd=!1,this.useOnRemove=!1,this.wrapperId="",this.contentIds=[],this.ariaTabIndex=null,this.chipAppendDelay=DEFAULT_CHIP_APPEND_DELAY,this.deRegister=[],this.addedMessage="added",this.removedMessage="removed",this.init()}angular.module("material.components.chips").controller("MdChipsCtrl",MdChipsCtrl),MdChipsCtrl.prototype.init=function(){var e=this;this.wrapperId="_md-chips-wrapper-"+this.$mdUtil.nextUid(),this.$element.attr("ng-model")||this.setupStaticChips(),this.deRegister.push(this.$scope.$watchCollection("$mdChipsCtrl.items",function(){e.setupInputAria(),e.setupWrapperAria()})),this.deRegister.push(this.$attrs.$observe("mdChipAppendDelay",function(t){e.chipAppendDelay=parseInt(t)||DEFAULT_CHIP_APPEND_DELAY}))},MdChipsCtrl.prototype.$onDestroy=function(){for(var t;t=this.deRegister.pop();)t.call(this)},MdChipsCtrl.prototype.setupInputAria=function(){var t=this.$element.find("input");t&&(t.attr("role","textbox"),t.attr("aria-multiline",!0),this.inputAriaDescribedBy&&t.attr("aria-describedby",this.inputAriaDescribedBy),this.inputAriaLabelledBy?(t.attr("aria-labelledby",this.inputAriaLabelledBy),t.removeAttr("aria-label")):t.attr("aria-label",this.inputAriaLabel))},MdChipsCtrl.prototype.setupWrapperAria=function(){var t=this,e=this.$element.find("md-chips-wrap");this.items&&this.items.length?(e.attr("role","listbox"),this.contentIds=this.items.map(function(){return t.wrapperId+"-chip-"+t.$mdUtil.nextUid()}),e.attr("aria-owns",this.contentIds.join(" ")),e.attr("aria-label",this.containerHint)):(e.removeAttr("role"),e.removeAttr("aria-owns"),e.attr("aria-label",this.containerEmptyHint))},MdChipsCtrl.prototype.setupStaticChips=function(){var t,e,i=this,n=this.$element.find("md-chips-wrap");this.$timeout(function(){for(n.attr("role","list"),e=n[0].children,t=0;t<e.length;t++)e[t].setAttribute("role","listitem"),e[t].setAttribute("aria-setsize",e.length);i.inputAriaDescribedBy&&n.attr("aria-describedby",i.inputAriaDescribedBy),i.inputAriaLabelledBy?(n.attr("aria-labelledby",i.inputAriaLabelledBy),n.removeAttr("aria-label")):n.attr("aria-label",i.inputAriaLabel)},10)},MdChipsCtrl.prototype.inputKeydown=function(t){var e=this.getChipBuffer();if(!(this.autocompleteCtrl&&t.isDefaultPrevented&&t.isDefaultPrevented())){if(t.keyCode===this.$mdConstant.KEY_CODE.BACKSPACE){if(0!==this.getCursorPosition(t.target))return;return t.preventDefault(),t.stopPropagation(),void(this.items.length&&this.selectAndFocusChipSafe(this.items.length-1))}if((!this.separatorKeys||this.separatorKeys.length<1)&&(this.separatorKeys=[this.$mdConstant.KEY_CODE.ENTER]),-1!==this.separatorKeys.indexOf(t.keyCode)){if(this.autocompleteCtrl&&this.requireMatch||!e)return;if(t.preventDefault(),this.hasMaxChipsReached())return;return this.appendChip(e.trim()),this.resetChipBuffer(),!1}}},MdChipsCtrl.prototype.getCursorPosition=function(e){try{if(e.selectionStart===e.selectionEnd)return e.selectionStart}catch(t){if(!e.value)return 0}},MdChipsCtrl.prototype.updateChipContents=function(t,e){0<=t&&t<this.items.length&&(this.items[t]=e,this.updateNgModel(!0))},MdChipsCtrl.prototype.isEditingChip=function(){return!!this.$element[0].querySelector("._md-chip-editing")},MdChipsCtrl.prototype._isChipObject=function(t){return angular.isObject(t)},MdChipsCtrl.prototype.isRemovable=function(){return!!this.ngModelCtrl&&(this.readonly?this.removable:!angular.isDefined(this.removable)||this.removable)},MdChipsCtrl.prototype.chipKeydown=function(t){if(!this.getChipBuffer()&&!this.isEditingChip())switch(t.keyCode){case this.$mdConstant.KEY_CODE.BACKSPACE:case this.$mdConstant.KEY_CODE.DELETE:if(this.selectedChip<0)return;if(t.preventDefault(),!this.isRemovable())return;this.removeAndSelectAdjacentChip(this.selectedChip,t);break;case this.$mdConstant.KEY_CODE.LEFT_ARROW:t.preventDefault(),(this.selectedChip<0||this.readonly&&0===this.selectedChip)&&(this.selectedChip=this.items.length),this.items.length&&this.selectAndFocusChipSafe(this.selectedChip-1);break;case this.$mdConstant.KEY_CODE.RIGHT_ARROW:t.preventDefault(),this.selectAndFocusChipSafe(this.selectedChip+1);break;case this.$mdConstant.KEY_CODE.ESCAPE:case this.$mdConstant.KEY_CODE.TAB:if(this.selectedChip<0)return;t.preventDefault(),this.onFocus()}},MdChipsCtrl.prototype.getPlaceholder=function(){return this.items&&this.items.length&&(""===this.secondaryPlaceholder||this.secondaryPlaceholder)?this.secondaryPlaceholder:this.placeholder},MdChipsCtrl.prototype.removeAndSelectAdjacentChip=function(t,e){var i=this,n=i.getAdjacentChipIndex(t);this.$element[0].querySelector("md-chips-wrap"),this.$element[0].querySelector('md-chip[index="'+t+'"]');i.removeChip(t,e),i.$timeout(function(){i.$timeout(function(){i.selectAndFocusChipSafe(n)})})},MdChipsCtrl.prototype.resetSelectedChip=function(){this.selectedChip=-1,this.ariaTabIndex=null},MdChipsCtrl.prototype.getAdjacentChipIndex=function(t){var e=this.items.length-1;return 0==e?-1:t===e?t-1:t},MdChipsCtrl.prototype.appendChip=function(e){if(this.shouldFocusLastChip=!this.addOnBlur,this.useTransformChip&&this.transformChip){var t=this.transformChip({$chip:e});angular.isDefined(t)&&(e=t)}if(angular.isObject(e)&&this.items.some(function(t){return angular.equals(e,t)}))return;if(!(null==e||this.items.indexOf(e)+1)){var i=this.items.push(e)-1;this.updateNgModel();var n=angular.isObject(e)?"":e;this.$mdLiveAnnouncer.announce(n+" "+this.addedMessage,"assertive"),this.useOnAdd&&this.onAdd&&this.onAdd({$chip:e,$index:i})}},MdChipsCtrl.prototype.useTransformChipExpression=function(){this.useTransformChip=!0},MdChipsCtrl.prototype.useOnAddExpression=function(){this.useOnAdd=!0},MdChipsCtrl.prototype.useOnRemoveExpression=function(){this.useOnRemove=!0},MdChipsCtrl.prototype.useOnSelectExpression=function(){this.useOnSelect=!0},MdChipsCtrl.prototype.getChipBuffer=function(){var t=this.userInputElement?this.userInputNgModelCtrl?this.userInputNgModelCtrl.$viewValue:this.userInputElement[0].value:this.chipBuffer;return angular.isString(t)?t:""},MdChipsCtrl.prototype.resetChipBuffer=function(){this.userInputElement?this.userInputNgModelCtrl?(this.userInputNgModelCtrl.$setViewValue(""),this.userInputNgModelCtrl.$render()):this.userInputElement[0].value="":this.chipBuffer=""},MdChipsCtrl.prototype.hasMaxChipsReached=function(){return angular.isString(this.maxChips)&&(this.maxChips=parseInt(this.maxChips,10)||0),0<this.maxChips&&this.items.length>=this.maxChips},MdChipsCtrl.prototype.validateModel=function(){this.ngModelCtrl.$setValidity("md-max-chips",!this.hasMaxChipsReached()),this.ngModelCtrl.$validate()},MdChipsCtrl.prototype.updateNgModel=function(t){t||this.validateModel(),angular.forEach(this.ngModelCtrl.$viewChangeListeners,function(t){try{t()}catch(t){this.$exceptionHandler(t)}})},MdChipsCtrl.prototype.removeChip=function(t,e){var i=this.items.splice(t,1);this.updateNgModel(),this.ngModelCtrl.$setDirty();var n=angular.isObject(i[0])?"":i[0];this.$mdLiveAnnouncer.announce(n+" "+this.removedMessage,"assertive"),i&&i.length&&this.useOnRemove&&this.onRemove&&this.onRemove({$chip:i[0],$index:t,$event:e})},MdChipsCtrl.prototype.removeChipAndFocusInput=function(t,e){this.removeChip(t,e),this.autocompleteCtrl?(this.autocompleteCtrl.hidden=!0,this.$mdUtil.nextTick(this.onFocus.bind(this))):this.onFocus()},MdChipsCtrl.prototype.selectAndFocusChipSafe=function(t){if(!this.items.length||-1===t)return this.focusInput();if(t>=this.items.length){if(!this.readonly)return this.onFocus();t=0}t=Math.max(t,0),t=Math.min(t,this.items.length-1),this.selectChip(t),this.focusChip(t)},MdChipsCtrl.prototype.focusLastChipThenInput=function(){var t=this;t.shouldFocusLastChip=!1,t.focusChip(this.items.length-1),t.$timeout(function(){t.focusInput()},t.chipAppendDelay)},MdChipsCtrl.prototype.focusInput=function(){this.selectChip(-1),this.onFocus()},MdChipsCtrl.prototype.selectChip=function(t){-1<=t&&t<=this.items.length?(this.selectedChip=t,this.useOnSelect&&this.onSelect&&this.onSelect({$chip:this.items[t]})):this.$log.warn("Selected Chip index out of bounds; ignoring.")},MdChipsCtrl.prototype.focusChip=function(t){var e=this.$element[0].querySelector('md-chip[index="'+t+'"] .md-chip-content');this.ariaTabIndex=t,e.focus()},MdChipsCtrl.prototype.configureNgModel=function(t){this.ngModelCtrl=t;var e=this;t.$isEmpty=function(t){return!t||0===t.length},t.$render=function(){e.items=e.ngModelCtrl.$viewValue}},MdChipsCtrl.prototype.onFocus=function(){var t=this.$element[0].querySelector("input");t&&t.focus(),this.resetSelectedChip()},MdChipsCtrl.prototype.onInputFocus=function(){this.inputHasFocus=!0,this.setupInputAria(),this.resetSelectedChip()},MdChipsCtrl.prototype.onInputBlur=function(){this.inputHasFocus=!1,this.shouldAddOnBlur()&&(this.appendChip(this.getChipBuffer().trim()),this.resetChipBuffer())},MdChipsCtrl.prototype.configureInput=function(t){var e=t.controller("ngModel"),i=this;e&&(this.deRegister.push(this.$scope.$watch(function(){return e.$touched},function(t){t&&i.ngModelCtrl.$setTouched()})),this.deRegister.push(this.$scope.$watch(function(){return e.$dirty},function(t){t&&i.ngModelCtrl.$setDirty()})))},MdChipsCtrl.prototype.configureUserInput=function(t){var e=(this.userInputElement=t).controller("ngModel");e!==this.ngModelCtrl&&(this.userInputNgModelCtrl=e);function i(t,e){n.$evalAsync(angular.bind(s,e,t))}var n=this.$scope,s=this;t.attr({tabindex:0}).on("keydown",function(t){i(t,s.inputKeydown)}).on("focus",function(t){i(t,s.onInputFocus)}).on("blur",function(t){i(t,s.onInputBlur)})},MdChipsCtrl.prototype.configureAutocomplete=function(t){t&&(this.autocompleteCtrl=t,this.$element.attr("container-empty-hint")||(this.containerEmptyHint="Chips container with autocompletion. Enter the text area, type text to search, and then use the up and down arrow keys to select an option. Press enter to add the selected option as a chip.",this.setupWrapperAria()),t.registerSelectedItemWatcher(angular.bind(this,function(t){if(t){if(this.hasMaxChipsReached())return;this.appendChip(t),this.resetChipBuffer()}})),this.$element.find("input").on("focus",angular.bind(this,this.onInputFocus)).on("blur",angular.bind(this,this.onInputBlur)))},MdChipsCtrl.prototype.shouldAddOnBlur=function(){this.validateModel();var t=this.getChipBuffer().trim(),e=this.ngModelCtrl.$isEmpty(this.ngModelCtrl.$modelValue)||this.ngModelCtrl.$valid,i=this.autocompleteCtrl&&!this.autocompleteCtrl.hidden;return this.userInputNgModelCtrl&&(e=e&&this.userInputNgModelCtrl.$valid),this.addOnBlur&&!this.requireMatch&&t&&e&&!i},MdChipsCtrl.prototype.hasFocus=function(){return this.inputHasFocus||0<=this.selectedChip},MdChipsCtrl.prototype.contentIdFor=function(t){return this.contentIds[t]},MdChips.$inject=["$mdTheming","$mdUtil","$compile","$log","$timeout","$$mdSvgRegistry"],angular.module("material.components.chips").directive("mdChips",MdChips);var MD_CHIPS_TEMPLATE='      <md-chips-wrap          id="{{$mdChipsCtrl.wrapperId}}"          tabindex="{{$mdChipsCtrl.readonly ? 0 : -1}}"          ng-keydown="$mdChipsCtrl.chipKeydown($event)"          ng-class="{ \'md-focused\': $mdChipsCtrl.hasFocus(),                       \'md-readonly\': !$mdChipsCtrl.ngModelCtrl || $mdChipsCtrl.readonly,                      \'md-removable\': $mdChipsCtrl.isRemovable() }"          class="md-chips">        <md-chip ng-repeat="$chip in $mdChipsCtrl.items"            index="{{$index}}"             ng-class="{\'md-focused\': $mdChipsCtrl.selectedChip == $index, \'md-readonly\': !$mdChipsCtrl.ngModelCtrl || $mdChipsCtrl.readonly}">          <div class="md-chip-content"              tabindex="{{$mdChipsCtrl.ariaTabIndex === $index ? 0 : -1}}"              id="{{$mdChipsCtrl.contentIdFor($index)}}"              role="option"              aria-selected="{{$mdChipsCtrl.selectedChip === $index}}"              aria-setsize="{{$mdChipsCtrl.items.length}}"              aria-posinset="{{$index+1}}"              ng-click="!$mdChipsCtrl.readonly && $mdChipsCtrl.focusChip($index)"              aria-label="{{$mdChipsCtrl._isChipObject($chip) ? \'\' : $chip + \'. \'}}{{$mdChipsCtrl.isRemovable() ? \'\' + $mdChipsCtrl.deleteHint : \'\'}}"               ng-focus="!$mdChipsCtrl.readonly && $mdChipsCtrl.selectChip($index)"              md-chip-transclude="$mdChipsCtrl.chipContentsTemplate"></div>          <div ng-if="$mdChipsCtrl.isRemovable()"               class="md-chip-remove-container"               tabindex="-1"               md-chip-transclude="$mdChipsCtrl.chipRemoveTemplate"></div>        </md-chip>        <div class="md-chip-input-container" ng-if="!$mdChipsCtrl.readonly && $mdChipsCtrl.ngModelCtrl">          <div md-chip-transclude="$mdChipsCtrl.chipInputTemplate"></div>        </div>      </md-chips-wrap>',CHIP_INPUT_TEMPLATE='        <input            class="md-input{{ $mdChipsCtrl.inputClass ? \' \' + $mdChipsCtrl.inputClass: \'\'}}"            tabindex="0"            aria-label="{{$mdChipsCtrl.inputAriaLabel}}"            placeholder="{{$mdChipsCtrl.getPlaceholder()}}"            ng-model="$mdChipsCtrl.chipBuffer"            ng-focus="$mdChipsCtrl.onInputFocus()"            ng-blur="$mdChipsCtrl.onInputBlur()"            ng-keydown="$mdChipsCtrl.inputKeydown($event)">',CHIP_DEFAULT_TEMPLATE="      <span>{{$chip}}</span>",CHIP_REMOVE_TEMPLATE='      <button          class="md-chip-remove"          ng-if="$mdChipsCtrl.isRemovable()"          ng-click="$mdChipsCtrl.removeChipAndFocusInput($$replacedScope.$index, $event)"          type="button"          tabindex="-1"          aria-label="{{$mdChipsCtrl.deleteButtonLabel}}{{$mdChipsCtrl._isChipObject($chip) ? \'\' : \' \' + $chip}}">        <md-icon md-svg-src="{{$mdChipsCtrl.mdCloseIcon}}" aria-hidden="true"></md-icon>      </button>';function MdChips(c,C,u,n,m,$){var g={chips:C.processTemplate(MD_CHIPS_TEMPLATE),input:C.processTemplate(CHIP_INPUT_TEMPLATE),default:C.processTemplate(CHIP_DEFAULT_TEMPLATE),remove:C.processTemplate(CHIP_REMOVE_TEMPLATE)};return{template:function(t,e){return e.$mdUserTemplate=t.clone(),g.chips},require:["mdChips"],restrict:"E",controller:"MdChipsCtrl",controllerAs:"$mdChipsCtrl",bindToController:!0,compile:function(t,o){var i=o.$mdUserTemplate;o.$mdUserTemplate=null;var p=e("md-chips>md-chip-template"),a=e(C.prefixer().buildList("md-chip-remove").map(function(t){return"md-chips>*["+t+"]"}).join(","))||g.remove,h=p||g.default,l=e("md-chips>md-autocomplete")||e("md-chips>input")||g.input,d=i.find("md-chip");i[0].querySelector("md-chip-template>*[md-chip-remove]")&&n.warn("invalid placement of md-chip-remove within md-chip-template.");function e(t){if(o.ngModel){var e=i[0].querySelector(t);return e&&e.outerHTML}}return function(t,e,i,n){C.initOptionalProperties(t,o),c(e);var s=n[0];if(p&&(s.enableChipEdit=!1),s.chipContentsTemplate=h,s.chipRemoveTemplate=a,s.chipInputTemplate=l,s.mdCloseIcon=$.mdCancel,e.attr({tabindex:-1}).on("focus",function(){s.onFocus()}).on("click",function(){s.readonly||-1!==s.selectedChip||s.onFocus()}),o.ngModel&&(s.configureNgModel(e.controller("ngModel")),i.mdTransformChip&&s.useTransformChipExpression(),i.mdOnAdd&&s.useOnAddExpression(),i.mdOnRemove&&s.useOnRemoveExpression(),i.mdOnSelect&&s.useOnSelectExpression(),l!==g.input&&t.$watch("$mdChipsCtrl.readonly",function(t){t||C.nextTick(function(){if(0===l.indexOf("<md-autocomplete")){var t=e.find("md-autocomplete");s.configureAutocomplete(t.controller("mdAutocomplete"))}s.configureUserInput(e.find("input"))})}),C.nextTick(function(){var t=e.find("input");t&&(s.configureInput(t),t.toggleClass("md-input",!0))})),0<d.length){var r=u(d.clone())(t.$parent);m(function(){e.find("md-chips-wrap").prepend(r)})}}},scope:{readonly:"=?readonly",removable:"=?mdRemovable",placeholder:"@?",secondaryPlaceholder:"@?",maxChips:"@?mdMaxChips",transformChip:"&mdTransformChip",onAdd:"&?mdOnAdd",onRemove:"&?mdOnRemove",addedMessage:"@?mdAddedMessage",removedMessage:"@?mdRemovedMessage",onSelect:"&?mdOnSelect",inputClass:"@?mdInputClass",inputAriaDescribedBy:"@?inputAriaDescribedby",inputAriaLabelledBy:"@?inputAriaLabelledby",inputAriaLabel:"@?",containerHint:"@?",containerEmptyHint:"@?",deleteHint:"@?",deleteButtonLabel:"@?",separatorKeys:"=?mdSeparatorKeys",requireMatch:"=?mdRequireMatch",chipAppendDelayString:"@?mdChipAppendDelay",ngChange:"&?"}}}function MdContactChipsCtrl(t,e,i){this.$element=e,this.$attrs=t,this.$timeout=i,this.selectedItem=null,this.searchText="",this.deRegister=[],this.init()}MdContactChipsCtrl.$inject=["$attrs","$element","$timeout"],angular.module("material.components.chips").controller("MdContactChipsCtrl",MdContactChipsCtrl),MdContactChipsCtrl.prototype.init=function(){var t=this,e=this.deRegister,i=this.$element;this.$timeout(function(){e.push(i.find("md-chips").controller("mdChips").$scope.$watchCollection("$mdChipsCtrl.items",function(){t.setupChipsAria(),t.setupAutocompleteAria()}))})},MdContactChipsCtrl.prototype.setupChipsAria=function(){var t=this.$element.find("md-chips"),e=t.controller("mdChips");this.removedMessage&&(e.removedMessage=this.removedMessage),this.containerHint&&(e.containerHint=this.containerHint),this.containerEmptyHint&&(t.attr("container-empty-hint",this.containerEmptyHint),e.containerEmptyHint=this.containerEmptyHint),this.deleteHint&&(e.deleteHint=this.deleteHint),this.inputAriaLabel&&(e.inputAriaLabel=this.inputAriaLabel),this.inputClass&&(e.inputClass=this.inputClass)},MdContactChipsCtrl.prototype.setupAutocompleteAria=function(){var t=this.$element.find("md-chips-wrap").find("md-autocomplete").find("input");this.inputAriaDescribedBy&&t.attr("aria-describedby",this.inputAriaDescribedBy),this.inputAriaLabelledBy&&(t.removeAttr("aria-label"),t.attr("aria-labelledby",this.inputAriaLabelledBy))},MdContactChipsCtrl.prototype.queryContact=function(t){return this.contactQuery({$query:t})},MdContactChipsCtrl.prototype.inputKeydown=function(t){if(this.separatorKeys&&!(this.separatorKeys.indexOf(t.keyCode)<0)){t.stopPropagation(),t.preventDefault();var e=angular.element(t.target).controller("mdAutocomplete");e.select(e.index)}},MdContactChipsCtrl.prototype.itemName=function(t){return t[this.contactName]},MdContactChipsCtrl.prototype.$onDestroy=function(){for(var t;t=this.deRegister.pop();)t.call(this)},MdContactChips.$inject=["$mdTheming","$mdUtil"],angular.module("material.components.chips").directive("mdContactChips",MdContactChips);var MD_CONTACT_CHIPS_TEMPLATE='      <md-chips class="md-contact-chips"          ng-model="$mdContactChipsCtrl.contacts"          ng-change="$mdContactChipsCtrl.ngChange($mdContactChipsCtrl.contacts)"          md-require-match="$mdContactChipsCtrl.requireMatch"          md-max-chips="{{$mdContactChipsCtrl.maxChips}}"          md-chip-append-delay="{{$mdContactChipsCtrl.chipAppendDelay}}"          md-separator-keys="$mdContactChipsCtrl.separatorKeys"          md-autocomplete-snap>          <md-autocomplete              md-menu-class="md-contact-chips-suggestions"              md-selected-item="$mdContactChipsCtrl.selectedItem"              md-search-text="$mdContactChipsCtrl.searchText"              md-items="item in $mdContactChipsCtrl.queryContact($mdContactChipsCtrl.searchText)"              md-item-text="$mdContactChipsCtrl.itemName(item)"              md-no-cache="true"              md-min-length="$mdContactChipsCtrl.minLength"              md-autoselect              ng-attr-md-input-class="{{$mdContactChipsCtrl.inputClass}}"              ng-keydown="$mdContactChipsCtrl.inputKeydown($event)"              placeholder="{{$mdContactChipsCtrl.contacts.length === 0 ?                  $mdContactChipsCtrl.placeholder : $mdContactChipsCtrl.secondaryPlaceholder}}">            <div class="md-contact-suggestion">              <img                   ng-src="{{item[$mdContactChipsCtrl.contactImage]}}"                  alt="{{item[$mdContactChipsCtrl.contactName]}}"                  ng-if="item[$mdContactChipsCtrl.contactImage]" />              <span class="md-contact-name" md-highlight-text="$mdContactChipsCtrl.searchText"                    md-highlight-flags="{{$mdContactChipsCtrl.highlightFlags}}">                {{item[$mdContactChipsCtrl.contactName]}}              </span>              <span class="md-contact-email" >{{item[$mdContactChipsCtrl.contactEmail]}}</span>            </div>          </md-autocomplete>          <md-chip-template>            <div class="md-contact-avatar">              <img                   ng-src="{{$chip[$mdContactChipsCtrl.contactImage]}}"                  alt="{{$chip[$mdContactChipsCtrl.contactName]}}"                  ng-if="$chip[$mdContactChipsCtrl.contactImage]" />            </div>            <div class="md-contact-name">              {{$chip[$mdContactChipsCtrl.contactName]}}            </div>          </md-chip-template>      </md-chips>';function MdContactChips(o,p){return{template:function(t,e){return MD_CONTACT_CHIPS_TEMPLATE},restrict:"E",controller:"MdContactChipsCtrl",controllerAs:"$mdContactChipsCtrl",bindToController:!0,compile:function(t,r){return function(t,e,i,n){var s=n;p.initOptionalProperties(t,r),o(e),e.attr("tabindex","-1"),i.$observe("mdChipAppendDelay",function(t){s.chipAppendDelay=t})}},scope:{contactQuery:"&mdContacts",placeholder:"@?",secondaryPlaceholder:"@?",contactName:"@mdContactName",contactImage:"@mdContactImage",contactEmail:"@mdContactEmail",contacts:"=ngModel",ngChange:"&?",requireMatch:"=?mdRequireMatch",minLength:"=?mdMinLength",maxChips:"=?mdMaxChips",highlightFlags:"@?mdHighlightFlags",chipAppendDelay:"@?mdChipAppendDelay",separatorKeys:"=?mdSeparatorKeys",removedMessage:"@?mdRemovedMessage",inputClass:"@?mdInputClass",inputAriaDescribedBy:"@?inputAriaDescribedby",inputAriaLabelledBy:"@?inputAriaLabelledby",inputAriaLabel:"@?",containerHint:"@?",containerEmptyHint:"@?",deleteHint:"@?"}}}ngmaterial.components.chips=angular.module("material.components.chips");