/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Arrays;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.internal.shared.Numerics;

final class Prefixes {
    private static final String DECA = "da";
    private static final char[] PREFIXES = new char[]{'E', 'G', 'M', 'P', 'T', 'Y', 'Z', 'a', 'c', 'd', 'f', 'h', 'k', 'm', 'n', 'p', 'y', 'z', '\u00b5', '\u03bc', '\u3372'};
    private static final byte[] POWERS = new byte[]{18, 9, 6, 15, 12, 24, 21, -18, -2, -1, -15, 2, 3, -3, -9, -12, -24, -21, -6, -6, 1};
    private static final char[] ENUM = new char[]{'y', 'z', 'a', 'f', 'p', 'n', '\u00b5', 'm', 'c', 'd', '\u3372', 'h', 'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};
    static final int MAX_POWER = 8;
    private static final LinearConverter[] CONVERTERS = new LinearConverter[POWERS.length];

    private Prefixes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LinearConverter converter(char prefix) {
        int i = Arrays.binarySearch(PREFIXES, prefix);
        if (i < 0) {
            return null;
        }
        LinearConverter[] linearConverterArray = CONVERTERS;
        synchronized (CONVERTERS) {
            LinearConverter c = CONVERTERS[i];
            if (c == null) {
                double denominator;
                double numerator;
                byte p = POWERS[i];
                if (p >= 0) {
                    numerator = MathFunctions.pow10(p);
                    denominator = 1.0;
                } else {
                    numerator = 1.0;
                    denominator = MathFunctions.pow10(-p);
                }
                Prefixes.CONVERTERS[i] = c = LinearConverter.scale(numerator, denominator);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return c;
        }
    }

    static char symbol(double scale, int power) {
        switch (power) {
            case 0: {
                return '\u0000';
            }
            case 1: {
                break;
            }
            case 2: {
                scale = Math.sqrt(scale);
                break;
            }
            case 3: {
                scale = Math.cbrt(scale);
                break;
            }
            default: {
                scale = Math.pow(scale, 1.0 / (double)power);
            }
        }
        int n = Numerics.toExp10(Math.getExponent(scale)) + 1;
        if (AbstractConverter.epsilonEquals(MathFunctions.pow10(n), scale)) {
            int i = Math.abs(n);
            switch (i) {
                case 0: {
                    return '\u0000';
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    if (i > 24 || i % 3 != 0) {
                        return '\u0000';
                    }
                    i = i / 3 + 2;
                }
            }
            return ENUM[n >= 0 ? 9 + i : 10 - i];
        }
        return '\u0000';
    }

    static String concat(char prefix, String unit) {
        return prefix == '\u3372' ? DECA + unit : prefix + unit;
    }

    static Unit<?> getUnit(String uom) {
        Unit<?> unit = Units.get(uom);
        if (unit == null && uom.length() >= 2) {
            String symbol;
            int power;
            LinearConverter c;
            int s = 1;
            char prefix = uom.charAt(0);
            if (prefix == 'd' && uom.charAt(1) == 'a') {
                prefix = '\u3372';
                s = 2;
            }
            if (AbstractUnit.isPrefixable(unit = Units.get(uom.substring(s))) && (c = Prefixes.converter(prefix)) != null && (power = ConventionalUnit.power(symbol = unit.getSymbol())) != 0) {
                if (power != 1) {
                    c = LinearConverter.pow(c, power, false);
                }
                symbol = Prefixes.concat(prefix, symbol);
                return new ConventionalUnit((AbstractUnit)unit, c, symbol.intern(), 0, 0);
            }
            unit = null;
        }
        return unit;
    }

    static <Q extends Quantity<Q>> ConventionalUnit<Q> pseudoSystemUnit(SystemUnit<Q> unit) {
        if ((unit.scope & 0xFFFFFFFD) == 0 && unit.dimension.numeratorIs('M')) {
            if (unit == Units.KILOGRAM) {
                return (ConventionalUnit)Units.GRAM;
            }
            String symbol = unit.getSymbol();
            if (symbol != null && symbol.length() >= 3 && symbol.startsWith("kg") && !AbstractUnit.isSymbolChar(symbol.codePointAt(2))) {
                symbol = symbol.substring(1);
                LinearConverter c = Prefixes.converter('m');
                return new ConventionalUnit<Q>(unit, c, symbol, 1, 0).unique(symbol);
            }
        }
        return null;
    }
}

