/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.sqlmm;

import java.util.Optional;
import org.apache.sis.filter.visitor.FunctionIdentifier;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.opengis.geometry.Envelope;

public enum SQLMM implements FunctionIdentifier
{
    ST_Dimension(GeometryType.GEOMETRY, Integer.class),
    ST_CoordDim(GeometryType.GEOMETRY, Integer.class),
    ST_GeometryType(GeometryType.GEOMETRY, String.class),
    ST_SRID(GeometryType.GEOMETRY, Integer.class),
    ST_Transform(2, 2, GeometryType.GEOMETRY, null, (Object)((Object)GeometryType.GEOMETRY)),
    ST_IsEmpty(GeometryType.GEOMETRY, Boolean.class),
    ST_IsSimple(GeometryType.GEOMETRY, Boolean.class),
    ST_IsValid(GeometryType.GEOMETRY, Boolean.class),
    ST_Is3D(GeometryType.GEOMETRY, Boolean.class),
    ST_IsMeasured(GeometryType.GEOMETRY, Boolean.class),
    ST_Boundary(GeometryType.GEOMETRY, (Object)((Object)GeometryType.GEOMETRY)),
    ST_Envelope(GeometryType.GEOMETRY, Envelope.class),
    ST_ConvexHull(GeometryType.GEOMETRY, (Object)((Object)GeometryType.GEOMETRY)),
    ST_Buffer(2, 2, GeometryType.GEOMETRY, null, (Object)((Object)GeometryType.GEOMETRY)),
    ST_Intersection((Object)((Object)GeometryType.GEOMETRY)),
    ST_Union((Object)((Object)GeometryType.GEOMETRY)),
    ST_Difference((Object)((Object)GeometryType.GEOMETRY)),
    ST_SymDifference((Object)((Object)GeometryType.GEOMETRY)),
    ST_Distance(Number.class),
    ST_Equals(Boolean.class),
    ST_Relate(2, 3, GeometryType.GEOMETRY, GeometryType.GEOMETRY, Boolean.class),
    ST_Disjoint(Boolean.class),
    ST_Intersects(Boolean.class),
    ST_Touches(Boolean.class),
    ST_Crosses(Boolean.class),
    ST_Within(Boolean.class),
    ST_Contains(Boolean.class),
    ST_Overlaps(Boolean.class),
    ST_AsText(GeometryType.GEOMETRY, String.class),
    ST_AsBinary(GeometryType.GEOMETRY, byte[].class),
    ST_GeomFromText(1, 2, null, null, (Object)((Object)GeometryType.GEOMETRY)),
    ST_GeomFromWKB(1, 2, null, null, (Object)((Object)GeometryType.GEOMETRY)),
    ST_Point(2, 3, null, null, (Object)((Object)GeometryType.POINT)),
    ST_X(GeometryType.POINT, Number.class),
    ST_Y(GeometryType.POINT, Number.class),
    ST_Z(GeometryType.POINT, Number.class),
    ST_ExplicitPoint(GeometryType.POINT, double[].class),
    ST_PointFromText(1, 2, null, null, (Object)((Object)GeometryType.POINT)),
    ST_PointFromWKB(1, 2, null, null, (Object)((Object)GeometryType.POINT)),
    ST_Length(GeometryType.GEOMETRY, Number.class),
    ST_StartPoint(GeometryType.LINESTRING, (Object)((Object)GeometryType.POINT)),
    ST_EndPoint(GeometryType.LINESTRING, (Object)((Object)GeometryType.POINT)),
    ST_IsClosed(GeometryType.LINESTRING, Boolean.class),
    ST_IsRing(GeometryType.LINESTRING, Boolean.class),
    ST_ToLineString(GeometryType.GEOMETRY, (Object)((Object)GeometryType.LINESTRING)),
    ST_LineString(1, 2, null, null, (Object)((Object)GeometryType.LINESTRING)),
    ST_NumPoints(GeometryType.LINESTRING, Integer.class),
    ST_PointN(2, 2, GeometryType.LINESTRING, null, (Object)((Object)GeometryType.POINT)),
    ST_LineFromText(1, 2, null, null, (Object)((Object)GeometryType.LINESTRING)),
    ST_LineFromWKB(1, 2, null, null, (Object)((Object)GeometryType.LINESTRING)),
    ST_Area(GeometryType.POLYGON, Number.class),
    ST_Perimeter(GeometryType.POLYGON, Number.class),
    ST_Centroid(GeometryType.GEOMETRY, (Object)((Object)GeometryType.POINT)),
    ST_PointOnSurface(GeometryType.GEOMETRY, (Object)((Object)GeometryType.POINT)),
    ST_Polygon(1, 2, null, null, (Object)((Object)GeometryType.POLYGON)),
    ST_ExteriorRing(GeometryType.POLYGON, (Object)((Object)GeometryType.LINESTRING)),
    ST_NumInteriorRings(GeometryType.POLYGON, Integer.class),
    ST_InteriorRingN(2, 2, GeometryType.POLYGON, null, (Object)((Object)GeometryType.LINESTRING)),
    ST_PolyFromText(1, 2, null, null, (Object)((Object)GeometryType.POLYGON)),
    ST_PolyFromWKB(1, 2, null, null, (Object)((Object)GeometryType.POLYGON)),
    ST_BdPolyFromText(1, 2, null, null, (Object)((Object)GeometryType.POLYGON)),
    ST_BdPolyFromWKB(1, 2, null, null, (Object)((Object)GeometryType.POLYGON)),
    ST_GeomCollection(1, 2, null, null, (Object)((Object)GeometryType.GEOMETRYCOLLECTION)),
    ST_NumGeometries(GeometryType.GEOMETRYCOLLECTION, Integer.class),
    ST_GeometryN(2, 2, GeometryType.GEOMETRYCOLLECTION, null, (Object)((Object)GeometryType.GEOMETRY)),
    ST_GeomCollFromText(1, 2, null, null, (Object)((Object)GeometryType.GEOMETRYCOLLECTION)),
    ST_GeomCollFromWKB(1, 2, null, null, (Object)((Object)GeometryType.GEOMETRYCOLLECTION)),
    ST_MultiPoint(1, 2, null, null, (Object)((Object)GeometryType.MULTIPOINT)),
    ST_MPointFromText(1, 2, null, null, (Object)((Object)GeometryType.MULTIPOINT)),
    ST_MPointFromWKB(1, 2, null, null, (Object)((Object)GeometryType.MULTIPOINT)),
    ST_MultiLineString(1, 2, null, null, (Object)((Object)GeometryType.MULTILINESTRING)),
    ST_MLineFromText(1, 2, null, null, (Object)((Object)GeometryType.MULTILINESTRING)),
    ST_MLineFromWKB(1, 2, null, null, (Object)((Object)GeometryType.MULTILINESTRING)),
    ST_MultiPolygon(1, 2, null, null, (Object)((Object)GeometryType.MULTIPOLYGON)),
    ST_MPolyFromText(1, 2, null, null, (Object)((Object)GeometryType.MULTIPOLYGON)),
    ST_MPolyFromWKB(1, 2, null, null, (Object)((Object)GeometryType.MULTIPOLYGON)),
    ST_BdMPolyFromText(1, 2, null, null, (Object)((Object)GeometryType.MULTIPOLYGON)),
    ST_BdMPolyFromWKB(1, 2, null, null, (Object)((Object)GeometryType.MULTIPOLYGON)),
    ST_ToPoint(GeometryType.GEOMETRY, (Object)((Object)GeometryType.POINT)),
    ST_ToPolygon(GeometryType.GEOMETRY, (Object)((Object)GeometryType.POLYGON)),
    ST_ToMultiPoint(GeometryType.GEOMETRY, (Object)((Object)GeometryType.MULTIPOINT)),
    ST_ToMultiLine(GeometryType.GEOMETRY, (Object)((Object)GeometryType.MULTILINESTRING)),
    ST_ToMultiPolygon(GeometryType.GEOMETRY, (Object)((Object)GeometryType.MULTIPOLYGON)),
    ST_ToGeomColl(GeometryType.GEOMETRY, (Object)((Object)GeometryType.GEOMETRYCOLLECTION)),
    ST_Simplify(2, 2, GeometryType.GEOMETRY, null, (Object)((Object)GeometryType.GEOMETRY)),
    ST_SimplifyPreserveTopology(2, 2, GeometryType.GEOMETRY, null, (Object)((Object)GeometryType.GEOMETRY));

    public final byte minParamCount;
    public final byte maxParamCount;
    final GeometryType geometryType1;
    final GeometryType geometryType2;
    private final Object returnType;

    private SQLMM(GeometryType geometryType1, Object returnType) {
        this.minParamCount = 1;
        this.maxParamCount = 1;
        this.geometryType1 = geometryType1;
        this.geometryType2 = null;
        this.returnType = returnType;
    }

    private SQLMM(Object returnType) {
        this.minParamCount = (byte)2;
        this.maxParamCount = (byte)2;
        this.geometryType1 = GeometryType.GEOMETRY;
        this.geometryType2 = GeometryType.GEOMETRY;
        this.returnType = returnType;
    }

    private SQLMM(int minParamCount, int maxParamCount, GeometryType geometryType1, GeometryType geometryType2, Object returnType) {
        this.minParamCount = (byte)minParamCount;
        this.maxParamCount = (byte)maxParamCount;
        this.geometryType1 = geometryType1;
        this.geometryType2 = geometryType2;
        this.returnType = returnType;
    }

    public final int geometryCount() {
        return this.geometryType1 == null ? 0 : (this.geometryType2 == null ? 1 : 2);
    }

    final boolean isGeometryInOut() {
        return this.geometryType1 != null && this.returnType instanceof GeometryType;
    }

    public final Optional<GeometryType> getGeometryType() {
        return this.returnType instanceof GeometryType ? Optional.of((GeometryType)((Object)this.returnType)) : Optional.empty();
    }

    public final Class<?> getReturnType(Geometries<?> library) {
        return this.returnType instanceof Class ? (Class<?>)this.returnType : library.getGeometryClass((GeometryType)((Object)this.returnType));
    }
}

