/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.storage.geotiff.base.Resources;
import org.apache.sis.storage.geotiff.writer.CompressionChannel;

final class ZIP
extends CompressionChannel {
    private final Deflater deflater;

    public ZIP(ChannelDataOutput output, long length, int level) {
        super(output, length);
        this.deflater = new Deflater(level);
    }

    @Override
    final ByteBuffer createBuffer() {
        return ByteBuffer.allocateDirect(this.bufferCapacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer source) throws IOException {
        ByteBuffer target = this.output.buffer;
        int start = source.position();
        int remaining = source.remaining();
        this.deflater.setInput(source);
        long numBytes = this.deflater.getBytesRead() + (long)remaining;
        if (numBytes >= this.length) {
            if (this.deflater.finished()) {
                throw new IOException(Resources.forLocale(null).getString((short)28, this.length, numBytes));
            }
            this.deflater.finish();
        }
        while (remaining > 0) {
            assert (!this.deflater.needsInput());
            this.output.ensureBufferAccepts(Math.min(remaining, target.capacity()));
            target.limit(target.capacity());
            try {
                if (this.deflater.deflate(target) == 0 && source.hasRemaining()) {
                    throw new ZipException(Resources.forLocale(null).getString((short)28, this.length, numBytes));
                }
            }
            finally {
                target.limit(target.position());
            }
            remaining = source.remaining();
        }
        return source.position() - start;
    }

    @Override
    public void finish(ChannelDataOutput owner) throws IOException {
        this.deflater.finish();
        super.finish(owner);
        ByteBuffer target = this.output.buffer;
        while (!this.deflater.finished()) {
            this.output.ensureBufferAccepts(Math.max(target.capacity() / 2, 1));
            target.limit(target.capacity());
            this.deflater.deflate(target);
            target.limit(target.position());
        }
        this.deflater.reset();
    }

    @Override
    public void close() {
        this.deflater.end();
    }
}

