/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.apm.testcase.thrift.server.service;

import org.apache.skywalking.apm.testcase.thrift.protocol.GreeterService;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TTransportException;

public class AsyncServer implements IServer {
    TNonblockingServer server;

    @Override
    public void start() throws TTransportException {
        TNonblockingServerSocket serverSocket = new TNonblockingServerSocket(9091);
        server = new TNonblockingServer(new TNonblockingServer.Args(serverSocket)
                                            .processor(new GreeterService.AsyncProcessor<>(new AsyncHandler()))
                                            .protocolFactory(TCompactProtocol::new));
        new Thread(() -> server.serve()).start();
    }

    @Override
    public void close() {
        server.stop();
    }
}
