/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.asf.dubbo;

import java.lang.reflect.Field;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.transport.AbstractServer;
import org.apache.skywalking.apm.agent.core.meter.Gauge;
import org.apache.skywalking.apm.agent.core.meter.MeterFactory;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;

public class AbstractServerConstructorInterceptor
implements InstanceConstructorInterceptor {
    private static final String METER_NAME = "thread_pool";
    private static final String METRIC_POOL_NAME_TAG_NAME = "pool_name";
    private static final String METRIC_TYPE_TAG_NAME = "metric_type";

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) throws Throwable {
        Field executorField = AbstractServer.class.getDeclaredField("executor");
        executorField.setAccessible(true);
        ExecutorService executor = (ExecutorService)executorField.get(objInst);
        URL url = (URL)allArguments[0];
        int port = url.getPort();
        if (!(executor instanceof ThreadPoolExecutor)) {
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
        String threadPoolName = String.format("DubboServerHandler-%s", port);
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getCorePoolSize()).tag(METRIC_POOL_NAME_TAG_NAME, threadPoolName)).tag(METRIC_TYPE_TAG_NAME, "core_pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getMaximumPoolSize()).tag(METRIC_POOL_NAME_TAG_NAME, threadPoolName)).tag(METRIC_TYPE_TAG_NAME, "max_pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getLargestPoolSize()).tag(METRIC_POOL_NAME_TAG_NAME, threadPoolName)).tag(METRIC_TYPE_TAG_NAME, "largest_pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getPoolSize()).tag(METRIC_POOL_NAME_TAG_NAME, threadPoolName)).tag(METRIC_TYPE_TAG_NAME, "pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getQueue().size()).tag(METRIC_POOL_NAME_TAG_NAME, threadPoolName)).tag(METRIC_TYPE_TAG_NAME, "queue_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getActiveCount()).tag(METRIC_POOL_NAME_TAG_NAME, threadPoolName)).tag(METRIC_TYPE_TAG_NAME, "active_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getTaskCount()).tag(METRIC_POOL_NAME_TAG_NAME, threadPoolName)).tag(METRIC_TYPE_TAG_NAME, "task_count")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getCompletedTaskCount()).tag(METRIC_POOL_NAME_TAG_NAME, threadPoolName)).tag(METRIC_TYPE_TAG_NAME, "completed_task_count")).build();
    }
}

