/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.quartz;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;

public class JobRunShellMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final AbstractTag JOB_GROUP = Tags.ofKey((String)"jobGroup");
    private static final AbstractTag JOB_NAME = Tags.ofKey((String)"jobName");
    private static final AbstractTag JOB_DATA_MAP = Tags.ofKey((String)"jobDataMap");
    private static final String EMPTY_JOB_DATA_MAP_STRING = Collections.emptyMap().toString();

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        JobDetail jobDetail = (JobDetail)objInst.getSkyWalkingDynamicField();
        String jobGroup = jobDetail.getKey().getGroup();
        String jobName = jobDetail.getKey().getName();
        String operationName = ComponentsDefine.QUARTZ_SCHEDULER.getName() + "/" + jobDetail.getJobClass().getName();
        AbstractSpan span = ContextManager.createLocalSpan((String)operationName);
        span.setComponent((Component)ComponentsDefine.QUARTZ_SCHEDULER);
        Tags.LOGIC_ENDPOINT.set(span, "{\"logic-span\":true}");
        span.tag(JOB_GROUP, jobGroup == null ? "" : jobGroup);
        span.tag(JOB_NAME, jobName == null ? "" : jobName);
        span.tag(JOB_DATA_MAP, JobRunShellMethodInterceptor.getJobDataMapString(jobDetail));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private static String getJobDataMapString(JobDetail jobDetail) {
        Map wrappedMap;
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        if (jobDataMap != null && (wrappedMap = jobDataMap.getWrappedMap()) != null) {
            return wrappedMap.toString();
        }
        return EMPTY_JOB_DATA_MAP_STRING;
    }
}

