/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.baidu.brpc;

import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ServerInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Request request = (Request)allArguments[0];
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        if (request.getKvAttachment() == null) {
            request.setKvAttachment(new HashMap());
        }
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue((String)request.getKvAttachment().get(next.getHeadKey()));
        }
        AbstractSpan span = ContextManager.createEntrySpan((String)ServerInterceptor.generateOperationName(request), (ContextCarrier)contextCarrier);
        SpanLayer.asRPCFramework((AbstractSpan)span);
        span.setComponent((Component)ComponentsDefine.BRPC_JAVA);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Response response = (Response)allArguments[1];
        if (response != null && response.getException() != null) {
            AbstractSpan span = ContextManager.activeSpan();
            span.log(response.getException());
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan activeSpan = ContextManager.activeSpan();
        activeSpan.log(t);
    }

    private static String generateOperationName(Request request) {
        StringBuilder operationName = new StringBuilder(request.getServiceName());
        operationName.append(".").append(request.getMethodName());
        return operationName.toString();
    }
}

