/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.dbcp.v2;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.dbcp2.BasicDataSourceMXBean;
import org.apache.skywalking.apm.agent.core.meter.Gauge;
import org.apache.skywalking.apm.agent.core.meter.MeterFactory;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;

public class PoolingJmxRegisterInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String METER_NAME = "datasource";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (objInst.getSkyWalkingDynamicField() != null) {
            BasicDataSourceMXBean basicDataSource = (BasicDataSourceMXBean)objInst;
            String tagValue = (String)objInst.getSkyWalkingDynamicField();
            Map<String, Function<BasicDataSourceMXBean, Supplier<Double>>> metricMap = this.getMetrics();
            metricMap.forEach((key, value) -> ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, (Supplier)((Supplier)value.apply(basicDataSource))).tag("name", tagValue)).tag("status", key)).build());
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    private Map<String, Function<BasicDataSourceMXBean, Supplier<Double>>> getMetrics() {
        HashMap<String, Function<BasicDataSourceMXBean, Supplier<Double>>> metricMap = new HashMap<String, Function<BasicDataSourceMXBean, Supplier<Double>>>();
        metricMap.put("numActive", basicDataSource -> () -> basicDataSource.getNumActive());
        metricMap.put("maxTotal", basicDataSource -> () -> basicDataSource.getMaxTotal());
        metricMap.put("numIdle", basicDataSource -> () -> basicDataSource.getNumIdle());
        metricMap.put("maxWaitMillis", basicDataSource -> () -> basicDataSource.getMaxWaitMillis());
        metricMap.put("maxIdle", basicDataSource -> () -> basicDataSource.getMaxIdle());
        metricMap.put("minIdle", basicDataSource -> () -> basicDataSource.getMinIdle());
        metricMap.put("initialSize", basicDataSource -> () -> basicDataSource.getInitialSize());
        return metricMap;
    }
}

