/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.CommonFields;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Field;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Schema;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Struct;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Type;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.CollectionUtils;

public class DeleteRecordsRequest
extends AbstractRequest {
    public static final long HIGH_WATERMARK = -1L;
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String OFFSET_KEY_NAME = "offset";
    private static final Schema DELETE_RECORDS_REQUEST_PARTITION_V0 = new Schema(CommonFields.PARTITION_ID, new Field("offset", Type.INT64, "The offset before which the messages will be deleted. -1 means high-watermark for the partition."));
    private static final Schema DELETE_RECORDS_REQUEST_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(DELETE_RECORDS_REQUEST_PARTITION_V0)));
    private static final Schema DELETE_RECORDS_REQUEST_V0;
    private static final Schema DELETE_RECORDS_REQUEST_V1;
    private final int timeout;
    private final Map<TopicPartition, Long> partitionOffsets;

    public static Schema[] schemaVersions() {
        return new Schema[]{DELETE_RECORDS_REQUEST_V0, DELETE_RECORDS_REQUEST_V1};
    }

    public DeleteRecordsRequest(Struct struct, short version) {
        super(ApiKeys.DELETE_RECORDS, version);
        this.partitionOffsets = new HashMap<TopicPartition, Long>();
        for (Object topicStructObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicStruct = (Struct)topicStructObj;
            String topic = topicStruct.get(CommonFields.TOPIC_NAME);
            for (Object partitionStructObj : topicStruct.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionStruct = (Struct)partitionStructObj;
                int partition = partitionStruct.get(CommonFields.PARTITION_ID);
                long offset = partitionStruct.getLong(OFFSET_KEY_NAME);
                this.partitionOffsets.put(new TopicPartition(topic, partition), offset);
            }
        }
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
    }

    public DeleteRecordsRequest(int timeout, Map<TopicPartition, Long> partitionOffsets, short version) {
        super(ApiKeys.DELETE_RECORDS, version);
        this.timeout = timeout;
        this.partitionOffsets = partitionOffsets;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DELETE_RECORDS.requestSchema(this.version()));
        Map<String, Map<Integer, Long>> offsetsByTopic = CollectionUtils.groupPartitionDataByTopic(this.partitionOffsets);
        struct.set(TIMEOUT_KEY_NAME, (Object)this.timeout);
        ArrayList<Struct> topicStructArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, Long>> offsetsByTopicEntry : offsetsByTopic.entrySet()) {
            Struct topicStruct = struct.instance(TOPICS_KEY_NAME);
            topicStruct.set(CommonFields.TOPIC_NAME, offsetsByTopicEntry.getKey());
            ArrayList<Struct> partitionStructArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, Long> offsetsByPartitionEntry : offsetsByTopicEntry.getValue().entrySet()) {
                Struct partitionStruct = topicStruct.instance(PARTITIONS_KEY_NAME);
                partitionStruct.set(CommonFields.PARTITION_ID, offsetsByPartitionEntry.getKey());
                partitionStruct.set(OFFSET_KEY_NAME, (Object)offsetsByPartitionEntry.getValue());
                partitionStructArray.add(partitionStruct);
            }
            topicStruct.set(PARTITIONS_KEY_NAME, (Object)partitionStructArray.toArray());
            topicStructArray.add(topicStruct);
        }
        struct.set(TOPICS_KEY_NAME, (Object)topicStructArray.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<TopicPartition, DeleteRecordsResponse.PartitionResponse> responseMap = new HashMap<TopicPartition, DeleteRecordsResponse.PartitionResponse>();
        for (Map.Entry<TopicPartition, Long> entry : this.partitionOffsets.entrySet()) {
            responseMap.put(entry.getKey(), new DeleteRecordsResponse.PartitionResponse(-1L, Errors.forException(e)));
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new DeleteRecordsResponse(throttleTimeMs, responseMap);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.DELETE_RECORDS.latestVersion()));
    }

    public int timeout() {
        return this.timeout;
    }

    public Map<TopicPartition, Long> partitionOffsets() {
        return this.partitionOffsets;
    }

    public static DeleteRecordsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteRecordsRequest(ApiKeys.DELETE_RECORDS.parseRequest(version, buffer), version);
    }

    static {
        DELETE_RECORDS_REQUEST_V1 = DELETE_RECORDS_REQUEST_V0 = new Schema(new Field(TOPICS_KEY_NAME, new ArrayOf(DELETE_RECORDS_REQUEST_TOPIC_V0)), new Field(TIMEOUT_KEY_NAME, Type.INT32, "The maximum time to await a response in ms."));
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteRecordsRequest> {
        private final int timeout;
        private final Map<TopicPartition, Long> partitionOffsets;

        public Builder(int timeout, Map<TopicPartition, Long> partitionOffsets) {
            super(ApiKeys.DELETE_RECORDS);
            this.timeout = timeout;
            this.partitionOffsets = partitionOffsets;
        }

        @Override
        public DeleteRecordsRequest build(short version) {
            return new DeleteRecordsRequest(this.timeout, this.partitionOffsets, version);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(type=DeleteRecordsRequest").append(", timeout=").append(this.timeout).append(", partitionOffsets=(").append(this.partitionOffsets).append("))");
            return builder.toString();
        }
    }
}

