/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLLocation;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class DMURLParser
extends AbstractURLParser {
    private static final int DEFAULT_PORT = 5236;
    private static final String DB_TYPE = "DM";
    private static final String URL_PARAMS_HOST_KEY = "host";
    private static final String URL_PARAMS_PORT_KEY = "port";
    private static final String URL_PARAMS_SCHEMA_KEY = "schema";

    public DMURLParser(String url) {
        super(url);
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange() {
        int hostLabelStartIndex = this.url.indexOf("//");
        if (hostLabelStartIndex == -1) {
            return new URLLocation(0, 0);
        }
        int hostLabelEndIndex = this.url.indexOf("?", hostLabelStartIndex + 2);
        if (hostLabelEndIndex == -1) {
            hostLabelEndIndex = this.url.length();
        }
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange() {
        return new URLLocation(0, 0);
    }

    @Override
    public ConnectionInfo parse() {
        URLLocation location = this.fetchDatabaseHostsIndexRange();
        String hostPortSegment = "";
        if (location.endIndex() > location.startIndex()) {
            hostPortSegment = this.url.substring(location.startIndex(), location.endIndex());
        }
        String host = "";
        String port = "";
        if (!hostPortSegment.isEmpty()) {
            String[] parts = hostPortSegment.split(":");
            if (parts.length >= 1) {
                host = parts[0];
            }
            if (parts.length == 2) {
                port = parts[1];
            }
        }
        if (host.isEmpty()) {
            host = this.fetchFromUrlParams(URL_PARAMS_HOST_KEY);
        }
        if (port == null || port.isEmpty()) {
            port = this.fetchFromUrlParams(URL_PARAMS_PORT_KEY);
        }
        if (port == null || port.isEmpty()) {
            port = String.valueOf(5236);
        }
        String schema = this.fetchFromUrlParams(URL_PARAMS_SCHEMA_KEY);
        return new ConnectionInfo(ComponentsDefine.DMDB_JDBC_DRIVER, DB_TYPE, host, Integer.parseInt(port), schema == null ? "" : schema);
    }

    private String fetchFromUrlParams(String key) {
        String[] params;
        int paramIndex = this.url.indexOf("?");
        if (paramIndex == -1) {
            return null;
        }
        for (String pair : params = this.url.substring(paramIndex + 1).split("&")) {
            String[] segments;
            if (!pair.startsWith(key + "=") || (segments = pair.split("=", 2)).length != 2) continue;
            return segments[1];
        }
        return null;
    }
}

