/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.finagle;

import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.finagle.AbstractInterceptor;
import org.apache.skywalking.apm.plugin.finagle.ContextHolderFactory;
import org.apache.skywalking.apm.plugin.finagle.FinagleCtxs;
import org.apache.skywalking.apm.plugin.finagle.SWContextCarrier;
import org.apache.skywalking.apm.plugin.finagle.SWContextCarrier$;

public class ClientTracingFilterInterceptor
extends AbstractInterceptor {
    @Override
    protected void onConstructImpl(EnhancedInstance objInst, Object[] allArguments) {
    }

    @Override
    public void beforeMethodImpl(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, MethodInterceptResult methodInterceptResult) throws Throwable {
        AbstractSpan finagleSpan = ContextManager.createExitSpan((String)"pending", (String)"");
        finagleSpan.setComponent((Component)ComponentsDefine.FINAGLE);
        SpanLayer.asRPCFramework((AbstractSpan)finagleSpan);
        ContextHolderFactory.getLocalContextHolder().let(FinagleCtxs.SW_SPAN, finagleSpan);
        ContextHolderFactory.getMarshalledContextHolder().let((Object)SWContextCarrier$.MODULE$, new SWContextCarrier());
    }

    @Override
    public Object afterMethodImpl(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, Object ret) throws Throwable {
        final AbstractSpan finagleSpan = FinagleCtxs.getSpan();
        ContextHolderFactory.getLocalContextHolder().remove(FinagleCtxs.SW_SPAN);
        ContextHolderFactory.getMarshalledContextHolder().remove((Object)SWContextCarrier$.MODULE$);
        if (ret == null) {
            ContextManager.stopSpan((AbstractSpan)finagleSpan);
        } else {
            finagleSpan.prepareForAsync();
            ContextManager.stopSpan((AbstractSpan)finagleSpan);
            ((Future)ret).addEventListener((FutureEventListener)new FutureEventListener<Object>(){

                public void onSuccess(Object value) {
                    finagleSpan.asyncFinish();
                }

                public void onFailure(Throwable cause) {
                    finagleSpan.log(cause);
                    finagleSpan.asyncFinish();
                }
            });
        }
        return ret;
    }

    @Override
    public void handleMethodExceptionImpl(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, Throwable throwable) {
        ContextManager.activeSpan().log(throwable);
    }
}

