/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grpc.v1.client;

import com.google.common.base.Strings;
import io.grpc.Attributes;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.lang.reflect.Method;
import java.util.Arrays;
import lombok.Generated;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.ExitSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.grpc.v1.Constants;
import org.apache.skywalking.apm.plugin.grpc.v1.OperationNameFormatUtil;
import org.apache.skywalking.apm.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCallImplGenericCallInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientCallImplGenericCallInterceptor.class);

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) throws Throwable {
        MethodDescriptor methodDescriptor = (MethodDescriptor)allArguments[0];
        objInst.setSkyWalkingDynamicField((Object)methodDescriptor);
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String asyncCallMethod = (String)ContextManager.getRuntimeContext().get((Object)"GENERIC_CALL_METHOD");
        if (StringUtil.isBlank((String)asyncCallMethod)) {
            return;
        }
        ContextManager.getRuntimeContext().remove((Object)"GENERIC_CALL_METHOD");
        ClientCall.Listener observer = (ClientCall.Listener)allArguments[0];
        Metadata headers = (Metadata)allArguments[1];
        MethodDescriptor methodDescriptor = (MethodDescriptor)objInst.getSkyWalkingDynamicField();
        String serviceName = OperationNameFormatUtil.formatOperationName(methodDescriptor);
        String remotePeer = "No Peer";
        String operationPrefix = OperationNameFormatUtil.formatOperationName(methodDescriptor) + "/client";
        ContextCarrier contextCarrier = new ContextCarrier();
        AbstractSpan span = ContextManager.createExitSpan((String)serviceName, (ContextCarrier)contextCarrier, (String)remotePeer);
        span.setComponent((Component)ComponentsDefine.GRPC);
        span.setLayer(SpanLayer.RPC_FRAMEWORK);
        span.tag(Constants.GENERIC_CALL_METHOD_TAG, asyncCallMethod);
        CarrierItem contextItem = contextCarrier.items();
        while (contextItem.hasNext()) {
            contextItem = contextItem.next();
            Metadata.Key headerKey = Metadata.Key.of((String)contextItem.getHeadKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            headers.put(headerKey, (Object)contextItem.getHeadValue());
        }
        ContextSnapshot snapshot = ContextManager.capture();
        span.prepareForAsync();
        ContextManager.stopSpan((AbstractSpan)span);
        objInst.setSkyWalkingDynamicField((Object)span);
        allArguments[0] = new TracingClientCallListener(observer, methodDescriptor, operationPrefix, snapshot, span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (objInst.getSkyWalkingDynamicField() == null || !(objInst.getSkyWalkingDynamicField() instanceof AbstractSpan)) {
            return ret;
        }
        AbstractSpan span = (AbstractSpan)objInst.getSkyWalkingDynamicField();
        String remotePeer = (String)ContextManager.getRuntimeContext().get((Object)"CLIENT_STREAM_PEER");
        ContextManager.getRuntimeContext().remove((Object)"CLIENT_STREAM_PEER");
        span.setPeer(remotePeer);
        Arrays.stream(objInst.getClass().getDeclaredMethods()).filter(m -> m.getName().equals("getAttributes")).findFirst().ifPresent(m -> {
            try {
                m.setAccessible(true);
                Attributes attributes = (Attributes)m.invoke((Object)objInst, new Object[0]);
                attributes.keys().stream().filter(k -> k.toString().equals("remote-addr")).findFirst().map(arg_0 -> ((Attributes)attributes).get(arg_0)).ifPresent(v -> {
                    String peer = v.toString();
                    if (StringUtil.isNotBlank((String)peer)) {
                        if (peer.startsWith("/")) {
                            peer = peer.substring(1);
                        }
                        span.setPeer(peer);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = (AbstractSpan)objInst.getSkyWalkingDynamicField();
        if (span != null) {
            span.errorOccurred().log(t);
        }
    }

    static class TracingClientCallListener<RESPONSE>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RESPONSE> {
        private final ContextSnapshot contextSnapshot;
        private final MethodDescriptor<?, ?> methodDescriptor;
        private final String operationPrefix;
        private final AbstractSpan asyncSpan;

        TracingClientCallListener(ClientCall.Listener<RESPONSE> delegate, MethodDescriptor<?, ?> methodDescriptor, String operationPrefix, ContextSnapshot contextSnapshot, AbstractSpan asyncSpan) {
            super(delegate);
            this.methodDescriptor = methodDescriptor;
            this.operationPrefix = operationPrefix;
            this.contextSnapshot = contextSnapshot;
            this.asyncSpan = asyncSpan;
        }

        public void onMessage(RESPONSE message) {
            if (this.methodDescriptor.getType().serverSendsOneMessage()) {
                super.onMessage(message);
            } else {
                AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Response/onMessage"));
                span.setComponent((Component)ComponentsDefine.GRPC);
                span.setLayer(SpanLayer.RPC_FRAMEWORK);
                ContextManager.continued((ContextSnapshot)this.contextSnapshot);
                try {
                    this.delegate().onMessage(message);
                }
                catch (Throwable t) {
                    span.log(t);
                    throw t;
                }
                finally {
                    ContextManager.stopSpan((AbstractSpan)span);
                }
            }
        }

        public void onClose(Status status, Metadata trailers) {
            if (!status.isOk()) {
                this.asyncSpan.log((Throwable)status.asRuntimeException());
            }
            Tags.RPC_RESPONSE_STATUS_CODE.set(this.asyncSpan, status.getCode().name());
            try {
                this.delegate().onClose(status, trailers);
            }
            catch (Throwable t) {
                this.asyncSpan.log(t);
                throw t;
            }
            finally {
                ExitSpan exitSpan;
                if (this.asyncSpan instanceof ExitSpan && ContextManager.getRuntimeContext().get((Object)"CLIENT_STREAM_PEER") != null && Strings.isNullOrEmpty((String)(exitSpan = (ExitSpan)this.asyncSpan).getPeer())) {
                    this.asyncSpan.setPeer((String)ContextManager.getRuntimeContext().get((Object)"CLIENT_STREAM_PEER"));
                    ContextManager.getRuntimeContext().remove((Object)"CLIENT_STREAM_PEER");
                }
                this.asyncSpan.asyncFinish();
            }
        }
    }
}

