/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.apm.agent.core.conf.RuntimeContextConfiguration;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.RuntimeContextSnapshot;

public class RuntimeContext {
    private final ThreadLocal<RuntimeContext> contextThreadLocal;
    private Map<Object, Object> context = new ConcurrentHashMap<Object, Object>(0);

    public RuntimeContext(ThreadLocal<RuntimeContext> contextThreadLocal) {
        this.contextThreadLocal = contextThreadLocal;
    }

    public void put(Object key, Object value) {
        this.context.put(key, value);
    }

    public Object get(Object key) {
        return this.context.get(key);
    }

    public <T> T get(Object key, Class<T> type) {
        return (T)this.context.get(key);
    }

    public void remove(Object key) {
        this.context.remove(key);
        if (this.context.isEmpty()) {
            this.contextThreadLocal.remove();
        }
    }

    public RuntimeContextSnapshot capture() {
        HashMap<Object, Object> runtimeContextMap = new HashMap<Object, Object>();
        for (String key : RuntimeContextConfiguration.NEED_PROPAGATE_CONTEXT_KEY) {
            Object value = this.get(key);
            if (value == null) continue;
            runtimeContextMap.put(key, value);
        }
        return new RuntimeContextSnapshot(runtimeContextMap);
    }

    public void accept(RuntimeContextSnapshot snapshot) {
        Iterator<Map.Entry<Object, Object>> iterator = snapshot.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> runtimeContextItem = iterator.next();
            ContextManager.getRuntimeContext().put(runtimeContextItem.getKey(), runtimeContextItem.getValue());
        }
    }
}

