/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin;

import java.lang.reflect.Method;
import java.net.http.HttpHeaders;
import java.util.HashMap;
import java.util.List;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;

public class HttpRequestHeadersInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextCarrier contextCarrier = (ContextCarrier)objInst.getSkyWalkingDynamicField();
        HttpHeaders originalHeaders = (HttpHeaders)ret;
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>(originalHeaders.map());
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            headerMap.put(next.getHeadKey(), List.of(next.getHeadValue()));
        }
        return HttpHeaders.of(headerMap, (k, v) -> true);
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

