/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.admin;

import java.util.Objects;

public class FeatureUpdate {
    private final short maxVersionLevel;
    private final UpgradeType upgradeType;

    @Deprecated
    public FeatureUpdate(short maxVersionLevel, boolean allowDowngrade) {
        this(maxVersionLevel, allowDowngrade ? UpgradeType.SAFE_DOWNGRADE : UpgradeType.UPGRADE);
    }

    public FeatureUpdate(short maxVersionLevel, UpgradeType upgradeType) {
        if (maxVersionLevel == 0 && upgradeType.equals((Object)UpgradeType.UPGRADE)) {
            throw new IllegalArgumentException(String.format("The upgradeType flag should be set to SAFE_DOWNGRADE or UNSAFE_DOWNGRADE when the provided maxVersionLevel:%d is < 1.", maxVersionLevel));
        }
        if (maxVersionLevel < 0) {
            throw new IllegalArgumentException("Cannot specify a negative version level.");
        }
        this.maxVersionLevel = maxVersionLevel;
        this.upgradeType = upgradeType;
    }

    public short maxVersionLevel() {
        return this.maxVersionLevel;
    }

    @Deprecated
    public boolean allowDowngrade() {
        return this.upgradeType != UpgradeType.UPGRADE;
    }

    public UpgradeType upgradeType() {
        return this.upgradeType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FeatureUpdate)) {
            return false;
        }
        FeatureUpdate that = (FeatureUpdate)other;
        return this.maxVersionLevel == that.maxVersionLevel && this.upgradeType.equals((Object)that.upgradeType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxVersionLevel, this.upgradeType});
    }

    public String toString() {
        return String.format("FeatureUpdate{maxVersionLevel:%d, upgradeType:%s}", new Object[]{this.maxVersionLevel, this.upgradeType});
    }

    public static enum UpgradeType {
        UNKNOWN(0),
        UPGRADE(1),
        SAFE_DOWNGRADE(2),
        UNSAFE_DOWNGRADE(3);

        private final byte code;

        private UpgradeType(int code) {
            this.code = (byte)code;
        }

        public byte code() {
            return this.code;
        }

        public static UpgradeType fromCode(int code) {
            if (code == 1) {
                return UPGRADE;
            }
            if (code == 2) {
                return SAFE_DOWNGRADE;
            }
            if (code == 3) {
                return UNSAFE_DOWNGRADE;
            }
            return UNKNOWN;
        }
    }
}

