/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.KafkaFuture;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ListOffsetsResult {
    private final Map<TopicPartition, KafkaFuture<ListOffsetsResultInfo>> futures;

    public ListOffsetsResult(Map<TopicPartition, KafkaFuture<ListOffsetsResultInfo>> futures) {
        this.futures = futures;
    }

    public KafkaFuture<ListOffsetsResultInfo> partitionResult(TopicPartition partition) {
        KafkaFuture<ListOffsetsResultInfo> future = this.futures.get(partition);
        if (future == null) {
            throw new IllegalArgumentException("List Offsets for partition \"" + partition + "\" was not attempted");
        }
        return future;
    }

    public KafkaFuture<Map<TopicPartition, ListOffsetsResultInfo>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(v -> {
            HashMap<TopicPartition, ListOffsetsResultInfo> offsets = new HashMap<TopicPartition, ListOffsetsResultInfo>(this.futures.size());
            for (Map.Entry<TopicPartition, KafkaFuture<ListOffsetsResultInfo>> entry : this.futures.entrySet()) {
                try {
                    offsets.put(entry.getKey(), entry.getValue().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            return offsets;
        });
    }

    public static class ListOffsetsResultInfo {
        private final long offset;
        private final long timestamp;
        private final Optional<Integer> leaderEpoch;

        public ListOffsetsResultInfo(long offset, long timestamp, Optional<Integer> leaderEpoch) {
            this.offset = offset;
            this.timestamp = timestamp;
            this.leaderEpoch = leaderEpoch;
        }

        public long offset() {
            return this.offset;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public Optional<Integer> leaderEpoch() {
            return this.leaderEpoch;
        }

        public String toString() {
            return "ListOffsetsResultInfo(offset=" + this.offset + ", timestamp=" + this.timestamp + ", leaderEpoch=" + this.leaderEpoch + ")";
        }
    }
}

