/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.ShareInFlightBatch;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicIdPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;

public class ShareFetch<K, V> {
    private final Map<TopicIdPartition, ShareInFlightBatch<K, V>> batches;

    public static <K, V> ShareFetch<K, V> empty() {
        return new ShareFetch<K, V>(new HashMap<TopicIdPartition, ShareInFlightBatch<K, V>>());
    }

    private ShareFetch(Map<TopicIdPartition, ShareInFlightBatch<K, V>> batches) {
        this.batches = batches;
    }

    public void add(TopicIdPartition partition, ShareInFlightBatch<K, V> batch) {
        Objects.requireNonNull(batch);
        ShareInFlightBatch<K, V> currentBatch = this.batches.get(partition);
        if (currentBatch == null) {
            this.batches.put(partition, batch);
        } else {
            currentBatch.merge(batch);
        }
    }

    public Map<TopicPartition, List<ConsumerRecord<K, V>>> records() {
        LinkedHashMap result = new LinkedHashMap();
        this.batches.forEach((tip, batch) -> result.put(tip.topicPartition(), batch.getInFlightRecords()));
        return Collections.unmodifiableMap(result);
    }

    public int numRecords() {
        int numRecords = 0;
        if (!this.batches.isEmpty()) {
            Iterator<Map.Entry<TopicIdPartition, ShareInFlightBatch<K, V>>> iterator = this.batches.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TopicIdPartition, ShareInFlightBatch<K, V>> entry = iterator.next();
                ShareInFlightBatch<K, V> batch = entry.getValue();
                if (batch.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                numRecords += batch.numRecords();
            }
        }
        return numRecords;
    }

    public boolean isEmpty() {
        return this.numRecords() == 0;
    }

    public void acknowledge(ConsumerRecord<K, V> record, AcknowledgeType type) {
        for (Map.Entry<TopicIdPartition, ShareInFlightBatch<K, V>> tipBatch : this.batches.entrySet()) {
            TopicIdPartition tip = tipBatch.getKey();
            if (!tip.topic().equals(record.topic()) || tip.partition() != record.partition()) continue;
            tipBatch.getValue().acknowledge(record, type);
            return;
        }
        throw new IllegalStateException("The record cannot be acknowledged.");
    }

    public void acknowledgeAll(AcknowledgeType type) {
        this.batches.forEach((tip, batch) -> batch.acknowledgeAll(type));
    }

    public Map<TopicIdPartition, Acknowledgements> takeAcknowledgedRecords() {
        LinkedHashMap<TopicIdPartition, Acknowledgements> acknowledgementMap = new LinkedHashMap<TopicIdPartition, Acknowledgements>();
        this.batches.forEach((tip, batch) -> {
            Acknowledgements acknowledgements = batch.takeAcknowledgedRecords();
            if (!acknowledgements.isEmpty()) {
                acknowledgementMap.put((TopicIdPartition)tip, acknowledgements);
            }
        });
        return acknowledgementMap;
    }
}

