/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.internals;

import java.util.Comparator;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.internals.ProducerBatch;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.PrimitiveRef;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ProducerIdAndEpoch;

class TxnPartitionEntry {
    static final int NO_LAST_ACKED_SEQUENCE_NUMBER = -1;
    private final TopicPartition topicPartition;
    private ProducerIdAndEpoch producerIdAndEpoch;
    private int nextSequence;
    private int lastAckedSequence;
    private SortedSet<ProducerBatch> inflightBatchesBySequence;
    private long lastAckedOffset;
    private static final Comparator<ProducerBatch> PRODUCER_BATCH_COMPARATOR = Comparator.comparingLong(ProducerBatch::producerId).thenComparingInt(ProducerBatch::producerEpoch).thenComparingInt(ProducerBatch::baseSequence);

    TxnPartitionEntry(TopicPartition topicPartition) {
        this.topicPartition = topicPartition;
        this.producerIdAndEpoch = ProducerIdAndEpoch.NONE;
        this.nextSequence = 0;
        this.lastAckedSequence = -1;
        this.lastAckedOffset = -1L;
        this.inflightBatchesBySequence = new TreeSet<ProducerBatch>(PRODUCER_BATCH_COMPARATOR);
    }

    ProducerIdAndEpoch producerIdAndEpoch() {
        return this.producerIdAndEpoch;
    }

    int nextSequence() {
        return this.nextSequence;
    }

    OptionalLong lastAckedOffset() {
        if (this.lastAckedOffset != -1L) {
            return OptionalLong.of(this.lastAckedOffset);
        }
        return OptionalLong.empty();
    }

    OptionalInt lastAckedSequence() {
        if (this.lastAckedSequence != -1) {
            return OptionalInt.of(this.lastAckedSequence);
        }
        return OptionalInt.empty();
    }

    boolean hasInflightBatches() {
        return !this.inflightBatchesBySequence.isEmpty();
    }

    ProducerBatch nextBatchBySequence() {
        return this.inflightBatchesBySequence.isEmpty() ? null : this.inflightBatchesBySequence.first();
    }

    void incrementSequence(int increment) {
        this.nextSequence = DefaultRecordBatch.incrementSequence(this.nextSequence, increment);
    }

    void addInflightBatch(ProducerBatch batch) {
        this.inflightBatchesBySequence.add(batch);
    }

    void setLastAckedOffset(long lastAckedOffset) {
        this.lastAckedOffset = lastAckedOffset;
    }

    void startSequencesAtBeginning(ProducerIdAndEpoch newProducerIdAndEpoch) {
        PrimitiveRef.IntRef sequence = PrimitiveRef.ofInt(0);
        this.resetSequenceNumbers(inFlightBatch -> {
            inFlightBatch.resetProducerState(newProducerIdAndEpoch, sequence.value);
            sequence.value += inFlightBatch.recordCount;
        });
        this.producerIdAndEpoch = newProducerIdAndEpoch;
        this.nextSequence = sequence.value;
        this.lastAckedSequence = -1;
    }

    int maybeUpdateLastAckedSequence(int sequence) {
        if (sequence > this.lastAckedSequence) {
            this.lastAckedSequence = sequence;
            return sequence;
        }
        return this.lastAckedSequence;
    }

    void removeInFlightBatch(ProducerBatch batch) {
        this.inflightBatchesBySequence.remove(batch);
    }

    void adjustSequencesDueToFailedBatch(long baseSequence, int recordCount) {
        this.decrementSequence(recordCount);
        this.resetSequenceNumbers(inFlightBatch -> {
            if ((long)inFlightBatch.baseSequence() < baseSequence) {
                return;
            }
            int newSequence = inFlightBatch.baseSequence() - recordCount;
            if (newSequence < 0) {
                throw new IllegalStateException("Sequence number for batch with sequence " + inFlightBatch.baseSequence() + " for partition " + this.topicPartition + " is going to become negative: " + newSequence);
            }
            inFlightBatch.resetProducerState(new ProducerIdAndEpoch(inFlightBatch.producerId(), inFlightBatch.producerEpoch()), newSequence);
        });
    }

    private void resetSequenceNumbers(Consumer<ProducerBatch> resetSequence) {
        TreeSet<ProducerBatch> newInflights = new TreeSet<ProducerBatch>(PRODUCER_BATCH_COMPARATOR);
        for (ProducerBatch inflightBatch : this.inflightBatchesBySequence) {
            resetSequence.accept(inflightBatch);
            newInflights.add(inflightBatch);
        }
        this.inflightBatchesBySequence = newInflights;
    }

    private boolean decrementSequence(int decrement) {
        int updatedSequence = this.nextSequence;
        if ((updatedSequence -= decrement) < 0) {
            throw new IllegalStateException("Sequence number for partition " + this.topicPartition + " is going to become negative: " + updatedSequence);
        }
        this.nextSequence = updatedSequence;
        return true;
    }
}

