-- This test suite checks the correctness of AbstractSqlParser.parseQuery

-- SPARK-51113, view read path

-- UNION

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1 AS num
  UNION
  SELECT 2
  UNION
  SELECT 3
  UNION
  SELECT 4
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1
  UNION
  SELECT 2
  UNION
  SELECT 3
  UNION
  SELECT 4
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1, 'a'
  UNION
  SELECT 2, 'b'
  UNION
  SELECT 3, 'c'
  UNION
  SELECT 4, 'd'
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1 AS num, 'a'
  UNION
  SELECT 2, 'b'
  UNION
  SELECT 3, 'c'
  UNION
  SELECT 4, 'd'
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1, 'a' AS a
  UNION
  SELECT 2, 'b'
  UNION
  SELECT 3, 'c'
  UNION
  SELECT 4, 'd'
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1 AS num, 'a' AS a
  UNION
  SELECT 2, 'b'
  UNION
  SELECT 3, 'c'
  UNION
  SELECT 4, 'd'
;
SELECT * FROM v1;

-- EXCEPT

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1 AS num
  EXCEPT
  SELECT 2
  EXCEPT
  SELECT 1
  EXCEPT
  SELECT 2
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1
  EXCEPT
  SELECT 2
  EXCEPT
  SELECT 1
  EXCEPT
  SELECT 2
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1, 'a'
  EXCEPT
  SELECT 2, 'b'
  EXCEPT
  SELECT 1, 'a'
  EXCEPT
  SELECT 2, 'b'
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1 AS num, 'a'
  EXCEPT
  SELECT 2, 'b'
  EXCEPT
  SELECT 1, 'a'
  EXCEPT
  SELECT 2, 'b'
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1, 'a' AS a
  EXCEPT
  SELECT 2, 'b'
  EXCEPT
  SELECT 1, 'a'
  EXCEPT
  SELECT 2, 'b'
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1 AS num, 'a' AS a
  EXCEPT
  SELECT 2, 'b'
  EXCEPT
  SELECT 1, 'a'
  EXCEPT
  SELECT 2, 'b'
;
SELECT * FROM v1;

-- INTERSECT

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1 AS num
  INTERSECT
  SELECT 1
  INTERSECT
  SELECT 2
  INTERSECT
  SELECT 2
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1
  INTERSECT
  SELECT 1
  INTERSECT
  SELECT 2
  INTERSECT
  SELECT 2
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1, 'a'
  INTERSECT
  SELECT 1, 'a'
  INTERSECT
  SELECT 2, 'b'
  INTERSECT
  SELECT 2, 'b'
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1 AS num, 'a'
  INTERSECT
  SELECT 1, 'a'
  INTERSECT
  SELECT 2, 'b'
  INTERSECT
  SELECT 2, 'b'
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1, 'a' AS a
  INTERSECT
  SELECT 1, 'a'
  INTERSECT
  SELECT 2, 'b'
  INTERSECT
  SELECT 2, 'b'
;
SELECT * FROM v1;

CREATE OR REPLACE TEMPORARY VIEW v1 AS
  SELECT 1 AS num, 'a' AS a
  INTERSECT
  SELECT 1, 'a'
  INTERSECT
  SELECT 2, 'b'
  INTERSECT
  SELECT 2, 'b'
;
SELECT * FROM v1;

DROP VIEW v1;

-- Views with schema evolution would give incorrect result.
-- The last column would be named 'UNION' on read, but schema evolution
-- would allow the 'a' -> 'UNION' rename on read.

CREATE OR REPLACE VIEW v1 WITH SCHEMA EVOLUTION AS
  SELECT 1, 'a'
  UNION
  SELECT 2, 'b'
  UNION
  SELECT 3, 'c'
  UNION
  SELECT 4, 'd'
;
SELECT * FROM v1;

CREATE OR REPLACE VIEW v1 WITH SCHEMA EVOLUTION AS
  SELECT 1 AS num, 'a'
  UNION
  SELECT 2, 'b'
  UNION
  SELECT 3, 'c'
  UNION
  SELECT 4, 'd'
;
SELECT * FROM v1;

CREATE OR REPLACE VIEW v1 WITH SCHEMA EVOLUTION AS
  SELECT 1 AS num, 'a' AS a
  UNION
  SELECT 2, 'b'
  UNION
  SELECT 3, 'c'
  UNION
  SELECT 4, 'd'
;
SELECT * FROM v1;

DROP VIEW v1;

-- SPARK-51113, EXECUTE IMMEDIATE ... INTO

DECLARE v1 INT;

EXECUTE IMMEDIATE 'SELECT 1 UNION SELECT 2 UNION SELECT 3' INTO v1;
SELECT v1;

EXECUTE IMMEDIATE 'SELECT 1 UNION SELECT 1 UNION SELECT 1' INTO v1;
SELECT v1;

EXECUTE IMMEDIATE 'SELECT 1 EXCEPT SELECT 2 EXCEPT SELECT 3' INTO v1;
SELECT v1;

EXECUTE IMMEDIATE 'SELECT 1 EXCEPT SELECT 1 EXCEPT SELECT 1' INTO v1;
SELECT v1;

EXECUTE IMMEDIATE 'SELECT 1 INTERSECT SELECT 2 INTERSECT SELECT 3' INTO v1;
SELECT v1;

EXECUTE IMMEDIATE 'SELECT 1 INTERSECT SELECT 1 INTERSECT SELECT 1' INTO v1;
SELECT v1;

-- Garbage queries

EXECUTE IMMEDIATE 'SELECT 1 JOIN SELECT 2' INTO v1;
SELECT v1;

EXECUTE IMMEDIATE 'SELECT 1 VALUES (1)' INTO v1;
SELECT v1;

EXECUTE IMMEDIATE 'SELECT 1 alias garbage garbage garbage' INTO v1;
SELECT v1;

EXECUTE IMMEDIATE 'SELECT 1 WITH abc' INTO v1;
SELECT v1;

DROP TEMPORARY VARIABLE v1;
