/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.flink.client.deployment.ClusterDeploymentException;
import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterRetrieveException;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ClusterClientProvider;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptionsInternal;
import org.apache.flink.kubernetes.configuration.KubernetesDeploymentTarget;
import org.apache.flink.kubernetes.entrypoint.KubernetesApplicationClusterEntrypoint;
import org.apache.flink.kubernetes.entrypoint.KubernetesSessionClusterEntrypoint;
import org.apache.flink.kubernetes.kubeclient.Endpoint;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.KubernetesJobManagerSpecification;
import org.apache.flink.kubernetes.kubeclient.factory.KubernetesJobManagerFactory;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.highavailability.nonha.standalone.StandaloneClientHAServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.runtime.rpc.AddressResolution;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClusterDescriptor
implements ClusterDescriptor<String> {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesClusterDescriptor.class);
    private static final String CLUSTER_DESCRIPTION = "Kubernetes cluster";
    private final Configuration flinkConfig;
    private final FlinkKubeClient client;
    private final String clusterId;

    public KubernetesClusterDescriptor(Configuration flinkConfig, FlinkKubeClient client) {
        this.flinkConfig = flinkConfig;
        this.client = client;
        this.clusterId = (String)Preconditions.checkNotNull((Object)flinkConfig.getString(KubernetesConfigOptions.CLUSTER_ID), (String)"ClusterId must be specified!");
    }

    public String getClusterDescription() {
        return CLUSTER_DESCRIPTION;
    }

    private ClusterClientProvider<String> createClusterClientProvider(String clusterId) {
        return () -> {
            Configuration configuration = new Configuration(this.flinkConfig);
            Optional<Endpoint> restEndpoint = this.client.getRestEndpoint(clusterId);
            if (!restEndpoint.isPresent()) {
                throw new RuntimeException((Throwable)new ClusterRetrieveException("Could not get the rest endpoint of " + clusterId));
            }
            configuration.setString(RestOptions.ADDRESS, restEndpoint.get().getAddress());
            configuration.setInteger(RestOptions.PORT, restEndpoint.get().getPort());
            try {
                return new RestClusterClient(configuration, (Object)clusterId, (effectiveConfiguration, fatalErrorHandler) -> new StandaloneClientHAServices(this.getWebMonitorAddress(effectiveConfiguration)));
            }
            catch (Exception e) {
                throw new RuntimeException((Throwable)new ClusterRetrieveException("Could not create the RestClusterClient.", (Throwable)e));
            }
        };
    }

    private String getWebMonitorAddress(Configuration configuration) throws Exception {
        AddressResolution resolution = AddressResolution.TRY_ADDRESS_RESOLUTION;
        KubernetesConfigOptions.ServiceExposedType serviceType = (KubernetesConfigOptions.ServiceExposedType)((Object)configuration.get(KubernetesConfigOptions.REST_SERVICE_EXPOSED_TYPE));
        if (serviceType.isClusterIP()) {
            resolution = AddressResolution.NO_ADDRESS_RESOLUTION;
            LOG.warn("Please note that Flink client operations(e.g. cancel, list, stop, savepoint, etc.) won't work from outside the Kubernetes cluster since '{}' has been set to {}.", (Object)KubernetesConfigOptions.REST_SERVICE_EXPOSED_TYPE.key(), (Object)serviceType);
        }
        return HighAvailabilityServicesUtils.getWebMonitorAddress((Configuration)configuration, (AddressResolution)resolution);
    }

    public ClusterClientProvider<String> retrieve(String clusterId) {
        ClusterClientProvider<String> clusterClientProvider = this.createClusterClientProvider(clusterId);
        try (ClusterClient clusterClient = clusterClientProvider.getClusterClient();){
            LOG.info("Retrieve flink cluster {} successfully, JobManager Web Interface: {}", (Object)clusterId, (Object)clusterClient.getWebInterfaceURL());
        }
        return clusterClientProvider;
    }

    public ClusterClientProvider<String> deploySessionCluster(ClusterSpecification clusterSpecification) throws ClusterDeploymentException {
        ClusterClientProvider<String> clusterClientProvider = this.deployClusterInternal(KubernetesSessionClusterEntrypoint.class.getName(), clusterSpecification, false);
        try (ClusterClient clusterClient = clusterClientProvider.getClusterClient();){
            LOG.info("Create flink session cluster {} successfully, JobManager Web Interface: {}", (Object)this.clusterId, (Object)clusterClient.getWebInterfaceURL());
        }
        return clusterClientProvider;
    }

    public ClusterClientProvider<String> deployApplicationCluster(ClusterSpecification clusterSpecification, ApplicationConfiguration applicationConfiguration) throws ClusterDeploymentException {
        if (this.client.getRestService(this.clusterId).isPresent()) {
            throw new ClusterDeploymentException("The Flink cluster " + this.clusterId + " already exists.");
        }
        Preconditions.checkNotNull((Object)clusterSpecification);
        Preconditions.checkNotNull((Object)applicationConfiguration);
        KubernetesDeploymentTarget deploymentTarget = KubernetesDeploymentTarget.fromConfig(this.flinkConfig);
        if (KubernetesDeploymentTarget.APPLICATION != deploymentTarget) {
            throw new ClusterDeploymentException("Couldn't deploy Kubernetes Application Cluster. Expected deployment.target=" + KubernetesDeploymentTarget.APPLICATION.getName() + " but actual one was \"" + (Object)((Object)deploymentTarget) + "\"");
        }
        applicationConfiguration.applyToConfiguration(this.flinkConfig);
        if (!PackagedProgramUtils.isPython((String)applicationConfiguration.getApplicationClassName()).booleanValue() && !PackagedProgramUtils.isPython((String[])applicationConfiguration.getProgramArguments())) {
            List<File> pipelineJars = KubernetesUtils.checkJarFileForApplicationMode(this.flinkConfig);
            Preconditions.checkArgument((pipelineJars.size() == 1 ? 1 : 0) != 0, (Object)"Should only have one jar");
        }
        ClusterClientProvider<String> clusterClientProvider = this.deployClusterInternal(KubernetesApplicationClusterEntrypoint.class.getName(), clusterSpecification, false);
        try (ClusterClient clusterClient = clusterClientProvider.getClusterClient();){
            LOG.info("Create flink application cluster {} successfully, JobManager Web Interface: {}", (Object)this.clusterId, (Object)clusterClient.getWebInterfaceURL());
        }
        return clusterClientProvider;
    }

    public ClusterClientProvider<String> deployJobCluster(ClusterSpecification clusterSpecification, JobGraph jobGraph, boolean detached) throws ClusterDeploymentException {
        throw new ClusterDeploymentException("Per-Job Mode not supported by Active Kubernetes deployments.");
    }

    private ClusterClientProvider<String> deployClusterInternal(String entryPoint, ClusterSpecification clusterSpecification, boolean detached) throws ClusterDeploymentException {
        ClusterEntrypoint.ExecutionMode executionMode = detached ? ClusterEntrypoint.ExecutionMode.DETACHED : ClusterEntrypoint.ExecutionMode.NORMAL;
        this.flinkConfig.setString(ClusterEntrypoint.INTERNAL_CLUSTER_EXECUTION_MODE, executionMode.toString());
        this.flinkConfig.setString(KubernetesConfigOptionsInternal.ENTRY_POINT_CLASS, entryPoint);
        KubernetesUtils.checkAndUpdatePortConfigOption(this.flinkConfig, (ConfigOption<String>)BlobServerOptions.PORT, 6124);
        KubernetesUtils.checkAndUpdatePortConfigOption(this.flinkConfig, (ConfigOption<String>)TaskManagerOptions.RPC_PORT, 6122);
        KubernetesUtils.checkAndUpdatePortConfigOption(this.flinkConfig, (ConfigOption<String>)RestOptions.BIND_PORT, 8081);
        if (HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)this.flinkConfig)) {
            this.flinkConfig.setString(HighAvailabilityOptions.HA_CLUSTER_ID, this.clusterId);
            KubernetesUtils.checkAndUpdatePortConfigOption(this.flinkConfig, (ConfigOption<String>)HighAvailabilityOptions.HA_JOB_MANAGER_PORT_RANGE, (Integer)this.flinkConfig.get(JobManagerOptions.PORT));
        }
        try {
            KubernetesJobManagerParameters kubernetesJobManagerParameters = new KubernetesJobManagerParameters(this.flinkConfig, clusterSpecification);
            FlinkPod podTemplate = kubernetesJobManagerParameters.getPodTemplateFilePath().map(file -> KubernetesUtils.loadPodFromTemplateFile(this.client, file, "flink-main-container")).orElse(new FlinkPod.Builder().build());
            KubernetesJobManagerSpecification kubernetesJobManagerSpec = KubernetesJobManagerFactory.buildKubernetesJobManagerSpecification(podTemplate, kubernetesJobManagerParameters);
            this.client.createJobManagerComponent(kubernetesJobManagerSpec);
            return this.createClusterClientProvider(this.clusterId);
        }
        catch (Exception e) {
            try {
                LOG.warn("Failed to create the Kubernetes cluster \"{}\", try to clean up the residual resources.", (Object)this.clusterId);
                this.client.stopAndCleanupCluster(this.clusterId);
            }
            catch (Exception e1) {
                LOG.info("Failed to stop and clean up the Kubernetes cluster \"{}\".", (Object)this.clusterId, (Object)e1);
            }
            throw new ClusterDeploymentException("Could not create Kubernetes cluster \"" + this.clusterId + "\".", (Throwable)e);
        }
    }

    public void killCluster(String clusterId) throws FlinkException {
        try {
            this.client.stopAndCleanupCluster(clusterId);
        }
        catch (Exception e) {
            throw new FlinkException("Could not kill Kubernetes cluster " + clusterId);
        }
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOG.error("failed to close client, exception {}", (Object)e.toString());
        }
    }
}

