/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.base.Predicate;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.AbstractNode;
import com.google.gxp.compiler.base.FormalTypeParameter;
import com.google.gxp.compiler.base.Import;
import com.google.gxp.compiler.base.JavaAnnotation;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.ThrowsDeclaration;
import com.google.gxp.compiler.base.Util;
import com.google.gxp.compiler.schema.Schema;
import java.util.List;

public abstract class AbstractRoot<T extends AbstractRoot>
extends AbstractNode
implements Root {
    private final TemplateName.FullyQualified name;
    private final Schema schema;
    private final ImmutableList<JavaAnnotation> javaAnnotations;
    private final ImmutableList<Parameter> parameters;
    private final ImmutableList<Import> imports;
    private final ImmutableList<ThrowsDeclaration> throwsDeclarations;
    private final ImmutableList<FormalTypeParameter> formalTypeParameters;

    protected AbstractRoot(SourcePosition pos, String displayName, TemplateName.FullyQualified name, Schema schema, List<JavaAnnotation> javaAnnotations, List<Import> imports, List<ThrowsDeclaration> throwsDeclarations, List<Parameter> parameters, List<FormalTypeParameter> formalTypeParameters) {
        super(pos, displayName);
        this.name = Preconditions.checkNotNull(name);
        this.schema = Preconditions.checkNotNull(schema);
        this.javaAnnotations = ImmutableList.copyOf(javaAnnotations);
        this.imports = ImmutableList.copyOf(imports);
        this.throwsDeclarations = ImmutableList.copyOf(throwsDeclarations);
        this.parameters = ImmutableList.copyOf(parameters);
        this.formalTypeParameters = ImmutableList.copyOf(formalTypeParameters);
    }

    protected abstract T self();

    protected abstract T withParameters(List<Parameter> var1);

    public T transformParameters(Function<Parameter, Parameter> parameterTransformer) {
        ImmutableList<Parameter> newParameters = Util.map(this.getParameters(), parameterTransformer);
        return Iterables.elementsEqual(this.getParameters(), newParameters) ? this.self() : this.withParameters(newParameters);
    }

    @Override
    public TemplateName.FullyQualified getName() {
        return this.name;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    protected List<JavaAnnotation> getJavaAnnotations() {
        return this.javaAnnotations;
    }

    public Iterable<JavaAnnotation> getJavaAnnotations(final JavaAnnotation.Element element) {
        return Iterables.filter(this.javaAnnotations, new Predicate<JavaAnnotation>(){

            @Override
            public boolean apply(JavaAnnotation javaAnnotation) {
                return Objects.equal((Object)javaAnnotation.getElement(), (Object)element);
            }
        });
    }

    @Override
    public List<Import> getImports() {
        return this.imports;
    }

    public List<ThrowsDeclaration> getThrowsDeclarations() {
        return this.throwsDeclarations;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Parameter getParameterByPrimary(String paramName) {
        for (Parameter parameter : this.getParameters()) {
            if (!paramName.equals(parameter.getPrimaryName())) continue;
            return parameter;
        }
        return null;
    }

    public List<FormalTypeParameter> getFormalTypeParameters() {
        return this.formalTypeParameters;
    }
}

