/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.compiler.base.AbstractNode;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.FormalParameter;
import com.google.gxp.compiler.base.JavaAnnotation;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.SpaceOperatorSet;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class Parameter
extends AbstractNode {
    private final FormalParameter formal;
    private final ImmutableList<JavaAnnotation> javaAnnotations;
    private final Expression defaultValue;
    private final boolean hasDefaultFlag;
    private final Expression constructor;
    private final boolean hasConstructorFlag;
    private final Expression comment;
    public static final Function<Parameter, FormalParameter> GET_FORMAL = new Function<Parameter, FormalParameter>(){

        @Override
        public FormalParameter apply(Parameter from) {
            return from.getFormalParameter();
        }
    };

    public Parameter(FormalParameter formal, List<JavaAnnotation> javaAnnotations, Expression defaultValue, boolean hasDefaultFlag, Expression constructor, boolean hasConstructorFlag, Expression comment) {
        super(formal);
        this.formal = Preconditions.checkNotNull(formal);
        this.javaAnnotations = ImmutableList.copyOf(javaAnnotations);
        this.defaultValue = defaultValue;
        this.hasDefaultFlag = hasDefaultFlag;
        this.constructor = constructor;
        this.hasConstructorFlag = hasConstructorFlag;
        this.comment = Preconditions.checkNotNull(comment);
    }

    public Parameter(FormalParameter formal) {
        this(formal, Collections.emptyList(), null, false, null, false, new StringConstant(formal.getSourcePosition(), null, ""));
    }

    public Parameter withDefaultValue(Expression newDefaultValue) {
        if (Objects.equal(newDefaultValue, this.defaultValue)) {
            return this;
        }
        Preconditions.checkNotNull(this.defaultValue);
        Preconditions.checkNotNull(newDefaultValue);
        return new Parameter(this.formal, this.javaAnnotations, newDefaultValue, this.hasDefaultFlag, this.constructor, this.hasConstructorFlag, this.comment);
    }

    public Parameter withComment(Expression newComment) {
        return newComment.equals(this.comment) ? this : new Parameter(this.formal, this.javaAnnotations, this.defaultValue, this.hasDefaultFlag, this.constructor, this.hasConstructorFlag, newComment);
    }

    public FormalParameter getFormalParameter() {
        return this.formal;
    }

    public String getPrimaryName() {
        return this.formal.getPrimaryName();
    }

    public Set<String> getNames() {
        return this.formal.getNames();
    }

    public boolean consumesContent() {
        return this.formal.consumesContent();
    }

    public List<JavaAnnotation> getJavaAnnotations() {
        return this.javaAnnotations;
    }

    public Type getType() {
        return this.formal.getType();
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultFlag() {
        return this.hasDefaultFlag;
    }

    public Expression getConstructor() {
        return this.constructor;
    }

    public boolean hasConstructorFlag() {
        return this.hasConstructorFlag;
    }

    public Pattern getRegex() {
        return this.formal.getRegex();
    }

    public boolean regexMatches(ObjectConstant oc) {
        return this.formal.regexMatches(oc);
    }

    public SpaceOperatorSet getSpaceOperators() {
        return this.formal.getSpaceOperators();
    }

    public Expression getComment() {
        return this.comment;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Parameter && this.equals((Parameter)that);
    }

    public boolean equals(Parameter that) {
        return this.equalsAbstractNode(that) && Objects.equal(this.getFormalParameter(), that.getFormalParameter()) && Objects.equal(this.getJavaAnnotations(), that.getJavaAnnotations()) && Objects.equal(this.getDefaultValue(), that.getDefaultValue()) && Objects.equal(this.hasDefaultFlag(), that.hasDefaultFlag()) && Objects.equal(this.getConstructor(), that.getConstructor()) && Objects.equal(this.hasConstructorFlag(), that.hasConstructorFlag()) && Objects.equal(this.getComment(), that.getComment());
    }

    public int hashCode() {
        return Objects.hashCode(this.abstractNodeHashCode(), this.getFormalParameter(), this.getJavaAnnotations(), this.getDefaultValue(), this.hasDefaultFlag(), this.getConstructor(), this.hasConstructorFlag(), this.getComment());
    }
}

