/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.extend.ContainerConfigurationException;
import org.directwebremoting.extend.UninitializingBean;
import org.directwebremoting.impl.DefaultContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.ClassUtils;

public class SpringContainer
extends DefaultContainer
implements Container,
BeanFactoryAware,
UninitializingBean {
    protected BeanFactory beanFactory;
    private static final Log log = LogFactory.getLog(SpringContainer.class);

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void addParameter(String askFor, Object valueParam) throws ContainerConfigurationException {
        try {
            Class clz = ClassUtils.forName((String)askFor, (ClassLoader)ClassUtils.getDefaultClassLoader());
            Map beansOfType = ((ListableBeanFactory)this.beanFactory).getBeansOfType(clz);
            if (beansOfType.isEmpty()) {
                super.addParameter(askFor, valueParam);
            } else {
                if (beansOfType.size() > 1) {
                    throw new ContainerConfigurationException("multiple beans of type '" + clz.getName() + "' were found in the spring configuration");
                }
                this.beans.put(askFor, beansOfType.values().iterator().next());
            }
        }
        catch (ClassNotFoundException ex) {
            super.addParameter(askFor, valueParam);
        }
    }

    @Override
    public Object getBean(String id) {
        Object reply;
        try {
            reply = this.beanFactory.getBean(id);
        }
        catch (BeansException ex) {
            reply = super.getBean(id);
        }
        catch (IllegalStateException ex) {
            return super.getBean(id);
        }
        return reply;
    }

    @Override
    public Collection<String> getBeanNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.beanFactory instanceof ListableBeanFactory) {
            try {
                ListableBeanFactory listable = (ListableBeanFactory)this.beanFactory;
                names.addAll(Arrays.asList(listable.getBeanDefinitionNames()));
            }
            catch (IllegalStateException ex) {
                log.warn((Object)"List of beanNames does not include Spring beans since the BeanFactory was closed when we tried to read it.");
            }
        } else {
            log.warn((Object)"List of beanNames does not include Spring beans since your BeanFactory is not a ListableBeanFactory.");
        }
        names.addAll(super.getBeanNames());
        return Collections.unmodifiableCollection(names);
    }

    @Override
    protected void callInitializingBeans() {
        this.callInitializingBeans(super.getBeanNames());
    }

    @Override
    public void destroy() {
        super.destroy(super.getBeanNames());
    }
}

