/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.definition.dao;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.api.Definition;
import org.apache.tiles.core.definition.DefinitionsFactoryException;
import org.apache.tiles.core.definition.DefinitionsReader;
import org.apache.tiles.core.definition.RefreshMonitor;
import org.apache.tiles.core.definition.dao.DefinitionDAO;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationResource;

public abstract class BaseLocaleUrlDefinitionDAO
implements DefinitionDAO<Locale>,
RefreshMonitor {
    private static final Logger LOG = LogManager.getLogger(BaseLocaleUrlDefinitionDAO.class);
    protected List<ApplicationResource> sources;
    protected Map<String, Long> lastModifiedDates;
    protected DefinitionsReader reader;
    protected ApplicationContext applicationContext;

    public BaseLocaleUrlDefinitionDAO(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.lastModifiedDates = new HashMap<String, Long>();
    }

    public void setSources(List<ApplicationResource> sources) {
        ArrayList<ApplicationResource> defaultSources = new ArrayList<ApplicationResource>();
        for (ApplicationResource source : sources) {
            if (!Locale.ROOT.equals(source.getLocale())) continue;
            defaultSources.add(source);
        }
        this.sources = defaultSources;
    }

    public void setReader(DefinitionsReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean refreshRequired() {
        boolean status = false;
        Set<String> paths = this.lastModifiedDates.keySet();
        try {
            for (String path : paths) {
                Long lastModifiedDate = this.lastModifiedDates.get(path);
                ApplicationResource resource = this.applicationContext.getResource(path);
                long newModDate = resource.getLastModified();
                if (newModDate == lastModifiedDate) continue;
                status = true;
                break;
            }
        }
        catch (IOException e) {
            LOG.warn("Exception while monitoring update times.", (Throwable)e);
            return true;
        }
        return status;
    }

    protected Map<String, Definition> loadDefinitionsFromResource(ApplicationResource resource) {
        Map<String, Definition> defsMap = null;
        InputStream stream = null;
        try {
            this.lastModifiedDates.put(resource.getLocalePath(), resource.getLastModified());
            stream = resource.getInputStream();
            defsMap = this.reader.read(stream);
        }
        catch (FileNotFoundException e) {
            LOG.debug("File {} not found, continue", (Object)resource);
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("I/O error processing configuration.", e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return defsMap;
    }
}

