/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.definition.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tiles.api.Definition;
import org.apache.tiles.core.definition.pattern.DefinitionPatternMatcher;
import org.apache.tiles.core.definition.pattern.PatternDefinitionResolver;

public abstract class AbstractPatternDefinitionResolver<T>
implements PatternDefinitionResolver<T> {
    private final Map<T, List<DefinitionPatternMatcher>> localePatternPaths = new HashMap<T, List<DefinitionPatternMatcher>>();

    @Override
    public Definition resolveDefinition(String name, T customizationKey) {
        Definition retValue = null;
        if (this.localePatternPaths.containsKey(customizationKey)) {
            retValue = this.searchAndResolveDefinition(this.localePatternPaths.get(customizationKey), name);
        }
        return retValue;
    }

    @Override
    public Map<String, Definition> storeDefinitionPatterns(Map<String, Definition> localeDefsMap, T customizationKey) {
        List lpaths = this.localePatternPaths.computeIfAbsent(customizationKey, k -> new ArrayList());
        return this.addDefinitionsAsPatternMatchers(lpaths, localeDefsMap);
    }

    protected abstract Map<String, Definition> addDefinitionsAsPatternMatchers(List<DefinitionPatternMatcher> var1, Map<String, Definition> var2);

    private Definition searchAndResolveDefinition(List<DefinitionPatternMatcher> paths, String name) {
        DefinitionPatternMatcher wm;
        Definition d = null;
        Iterator<DefinitionPatternMatcher> iterator = paths.iterator();
        while (iterator.hasNext() && (d = (wm = iterator.next()).createDefinition(name)) == null) {
        }
        return d;
    }

    @Override
    public void clearPatternPaths(T customizationKey) {
        if (this.localePatternPaths.get(customizationKey) != null) {
            this.localePatternPaths.get(customizationKey).clear();
        }
    }
}

