/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.base.JRBaseExpression;
import net.sf.jasperreports.engine.design.JRDesignExpressionChunk;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;
import net.sf.jasperreports.engine.util.ExpressionParser;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignExpression
extends JRBaseExpression
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LEGACY_PARSER = "net.sf.jasperreports.legacy.expression.parser";
    protected static final boolean LEGACY_PARSER;
    public static final String PROPERTY_TEXT = "text";
    protected List<JRExpressionChunk> chunks = new ArrayList<JRExpressionChunk>();
    private transient JRPropertyChangeSupport eventSupport;

    public JRDesignExpression() {
        this.regenerateId();
    }

    public JRDesignExpression(String text) {
        this();
        this.setText(text);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setInterpreted() {
        this.id = ID_INTERPRETED;
    }

    public void setType(ExpressionTypeEnum type) {
        this.type = type;
    }

    @Override
    public JRExpressionChunk[] getChunks() {
        JRExpressionChunk[] chunkArray = null;
        if (this.chunks != null && this.chunks.size() > 0) {
            chunkArray = new JRExpressionChunk[this.chunks.size()];
            this.chunks.toArray(chunkArray);
        }
        return chunkArray;
    }

    public void setChunks(List<JRExpressionChunk> chunks) {
        this.chunks.clear();
        this.chunks.addAll(chunks);
    }

    public void addChunk(JRDesignExpressionChunk chunk) {
        this.chunks.add(chunk);
    }

    protected void addChunk(byte type, String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType(type);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addTextChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)1);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addParameterChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)2);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addFieldChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)3);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addVariableChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)4);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addResourceChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)5);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void setText(String text) {
        String old = this.getText();
        this.chunks.clear();
        if (text != null) {
            if (LEGACY_PARSER) {
                this.legacyParseText(text);
            } else {
                this.parseText(text);
            }
        }
        this.getEventSupport().firePropertyChange(PROPERTY_TEXT, old, text);
    }

    protected void legacyParseText(String text) {
        StringBuilder textChunk = new StringBuilder();
        StringTokenizer tkzer = new StringTokenizer(text, "$", true);
        int behindDelims = 0;
        while (tkzer.hasMoreTokens()) {
            String token = tkzer.nextToken();
            if (token.equals("$")) {
                if (behindDelims > 0) {
                    textChunk.append("$");
                }
                ++behindDelims;
                continue;
            }
            byte chunkType = 1;
            if (behindDelims > 0) {
                if (token.startsWith("P{")) {
                    chunkType = 2;
                } else if (token.startsWith("F{")) {
                    chunkType = 3;
                } else if (token.startsWith("V{")) {
                    chunkType = 4;
                } else if (token.startsWith("R{")) {
                    chunkType = 5;
                }
            }
            if (chunkType == 1) {
                if (behindDelims > 0) {
                    textChunk.append("$");
                }
                textChunk.append(token);
            } else {
                int end = token.indexOf(125);
                if (end > 0) {
                    if (behindDelims > 1) {
                        textChunk.append(token);
                    } else {
                        if (textChunk.length() > 0) {
                            this.addTextChunk(textChunk.toString());
                        }
                        this.addChunk(chunkType, token.substring(2, end));
                        textChunk = new StringBuilder(token.substring(end + 1));
                    }
                } else {
                    if (behindDelims > 0) {
                        textChunk.append("$");
                    }
                    textChunk.append(token);
                }
            }
            behindDelims = 0;
        }
        if (behindDelims > 0) {
            textChunk.append("$");
        }
        if (textChunk.length() > 0) {
            this.addTextChunk(textChunk.toString());
        }
    }

    protected void parseText(String text) {
        ExpressionParser.instance().parseExpression(text, new ExpressionParser.ParseResult(){

            @Override
            public void addTextChunk(String text) {
                JRDesignExpression.this.addTextChunk(text);
            }

            @Override
            public void addChunk(byte chunkType, String chunkText) {
                JRDesignExpression.this.addChunk(chunkType, chunkText);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignExpression jRDesignExpression = this;
        synchronized (jRDesignExpression) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public Object clone() {
        JRDesignExpression clone = (JRDesignExpression)super.clone();
        clone.chunks = JRCloneUtils.cloneList(this.chunks);
        clone.eventSupport = null;
        return clone;
    }

    static {
        JRPropertiesUtil properties = JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance());
        LEGACY_PARSER = properties.getBooleanProperty(PROPERTY_LEGACY_PARSER, false);
    }
}

