/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal;

import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.junit.Assert;

public class ThrowawayClassLoader
extends ClassLoader {
    private final ClassLoader parent;

    public ThrowawayClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                if (name.contains(".base.") || name.contains(".pages.") || name.contains(".components.") || name.contains(".mixins.")) {
                    byte[] bytes = PlasticInternalUtils.readBytecodeForClass((ClassLoader)this.parent, (String)name, (boolean)true);
                    c = this.defineClass(name, bytes, 0, bytes.length);
                    if (resolve) {
                        this.resolveClass(c);
                    }
                } else {
                    c = this.parent.loadClass(name);
                }
            }
            return c;
        }
    }

    public static void main(String[] args) throws Exception {
        String className = "org.apache.tapestry5.corelib.components.BeanEditor";
        ClassLoader parentClassLoader = ThrowawayClassLoader.class.getClassLoader();
        ClassLoader classLoader1 = ThrowawayClassLoader.create(parentClassLoader);
        ClassLoader classLoader2 = ThrowawayClassLoader.create(parentClassLoader);
        System.out.println("Parent class loader 1: " + parentClassLoader);
        System.out.println("Class loader 1       : " + classLoader1);
        System.out.println("Class loader 2       : " + classLoader2);
        Class<?> class1 = classLoader1.loadClass("org.apache.tapestry5.corelib.components.BeanEditor");
        Class<?> class2 = classLoader2.loadClass("org.apache.tapestry5.corelib.components.BeanEditor");
        Class<?> class3 = parentClassLoader.loadClass("org.apache.tapestry5.corelib.components.BeanEditor");
        System.out.println("Class 1 : " + class1.getClassLoader());
        System.out.println("Class 2 : " + class2.getClassLoader());
        System.out.println("Class 3 : " + class3.getClassLoader());
        Assert.assertNotEquals(class1, class2);
        Assert.assertNotEquals(class1, class3);
        Assert.assertNotEquals(class2, class3);
    }

    public static Class<?> load(String className) {
        ThrowawayClassLoader loader = new ThrowawayClassLoader(ThrowawayClassLoader.class.getClassLoader());
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static ClassLoader create(ClassLoader parentClassLoader) {
        return new ThrowawayClassLoader(parentClassLoader);
    }
}

