/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetcherErrorTestingConfig {
    private static final Logger LOG = LoggerFactory.getLogger(FetcherErrorTestingConfig.class);
    private static final String KEY_CACHED_HOSTNAME = "FetcherErrorTestingConfig.host";
    private String hostToFail = "*";
    private String srcNameTrimmedToFail = "*";
    private int probabilityPercent = 50;
    private Random random = new Random();
    private boolean failForFirstAttemptOnly = false;
    private ObjectRegistry objectRegistry;

    public FetcherErrorTestingConfig(Configuration conf, ObjectRegistry objectRegistry) {
        String host;
        List<String> features;
        String errorConfig = conf.get("tez.runtime.shuffle.fetch.testing.errors.config", "*#50");
        String[] configParts = errorConfig.split("#");
        if (configParts.length > 0) {
            this.hostToFail = configParts[0];
        }
        if (configParts.length > 1) {
            this.srcNameTrimmedToFail = TezUtilsInternal.cleanVertexName((String)configParts[1]);
        }
        if (configParts.length > 2) {
            this.probabilityPercent = Integer.parseInt(configParts[2]);
        }
        if (configParts.length > 3 && (features = Arrays.asList(configParts[3].split(","))).contains("fail_only_first")) {
            this.failForFirstAttemptOnly = true;
        }
        this.objectRegistry = objectRegistry;
        if (this.hostToFail.equals("_first_") && (host = (String)objectRegistry.get(KEY_CACHED_HOSTNAME)) != null) {
            LOG.info("Get already stored hostname for fetcher test failures: " + host);
            this.hostToFail = host;
        }
    }

    public boolean shouldFail(String host, String srcNameTrimmed, InputAttemptIdentifier inputAttemptIdentifier) {
        if (this.matchHost(host) && this.matchSourceVertex(srcNameTrimmed)) {
            return (!this.failForFirstAttemptOnly || this.failForFirstAttemptOnly && inputAttemptIdentifier.getAttemptNumber() == 0) && this.random.nextInt(100) < this.probabilityPercent;
        }
        return false;
    }

    private boolean matchHost(String host) {
        if (this.hostToFail.equals("_first_")) {
            this.objectRegistry.cacheForVertex(KEY_CACHED_HOSTNAME, (Object)host);
            this.hostToFail = host;
        }
        return "*".equals(this.hostToFail) || host.equalsIgnoreCase(this.hostToFail);
    }

    private boolean matchSourceVertex(String srcNameTrimmed) {
        return "*".equals(this.srcNameTrimmedToFail) || srcNameTrimmed.equalsIgnoreCase(this.srcNameTrimmedToFail);
    }

    public String toString() {
        return String.format("[FetcherErrorTestingConfig: host: %s, source vertex: %s, probability: %d%%, failForFirstAttemptOnly: %s]", this.hostToFail, this.srcNameTrimmedToFail, this.probabilityPercent, this.failForFirstAttemptOnly);
    }
}

