/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

public final class VertexProgramPool {
    private final LinkedBlockingQueue<VertexProgram<?>> pool;
    private static final int TIMEOUT_MS = 10000;

    public VertexProgramPool(VertexProgram vertexProgram, int poolSize) {
        this.pool = new LinkedBlockingQueue(poolSize);
        while (this.pool.remainingCapacity() > 0) {
            this.pool.add(vertexProgram.clone());
        }
    }

    public VertexProgram take() {
        try {
            return this.pool.poll(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void offer(VertexProgram<?> vertexProgram) {
        try {
            this.pool.offer(vertexProgram, 10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public synchronized void workerIterationStart(Memory memory) {
        for (VertexProgram<?> vertexProgram : this.pool) {
            vertexProgram.workerIterationStart(memory);
        }
    }

    public synchronized void workerIterationEnd(Memory memory) {
        for (VertexProgram<?> vertexProgram : this.pool) {
            vertexProgram.workerIterationEnd(memory);
        }
    }
}

