/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;

public final class AsBoolStep<S>
extends ScalarMapStep<S, Boolean> {
    public AsBoolStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected Boolean map(Traverser.Admin<S> traverser) {
        Object object = traverser.get();
        if (object == null) {
            throw new IllegalArgumentException("Can't parse null as Boolean.");
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (Double.isNaN(d)) {
                return false;
            }
            return d != 0.0;
        }
        if (object instanceof String) {
            String str = ((String)object).trim();
            if (str.equalsIgnoreCase("true")) {
                return true;
            }
            if (str.equalsIgnoreCase("false")) {
                return false;
            }
            throw new IllegalArgumentException("Can't parse " + object + " as Boolean.");
        }
        throw new IllegalArgumentException("Can't parse " + object.getClass().getName() + " as Boolean.");
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }
}

