/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.ejb;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.openejb.BeanContext;
import org.apache.openejb.api.internal.Internal;
import org.apache.openejb.api.jmx.Description;
import org.apache.openejb.api.jmx.MBean;
import org.apache.openejb.api.jmx.ManagedAttribute;
import org.apache.openejb.api.jmx.ManagedOperation;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.webservices.HandlerChainData;
import org.apache.openejb.core.webservices.HandlerData;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.loader.IO;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.server.cxf.CxfWsContainer;
import org.apache.openejb.server.cxf.ejb.EjbEndpoint;

public class EjbWsContainer
extends CxfWsContainer {
    private final BeanContext beanContext;
    private WsServiceMBean mbean;

    public EjbWsContainer(Bus bus, DestinationFactory transportFactory, PortData port, BeanContext beanContext, ServiceConfiguration config) {
        super(bus, transportFactory, port, config);
        if (beanContext == null) {
            throw new NullPointerException("deploymentInfo is null");
        }
        this.beanContext = beanContext;
    }

    @Override
    protected EjbEndpoint createEndpoint() {
        return new EjbEndpoint(this.bus, this.port, this.beanContext, this.transportFactory, this.serviceConfiguration);
    }

    @Override
    protected String getFakeUrl() {
        return this.beanContext.getEjbName().replace('/', '-') + "_ejb" + this.beanContext.hashCode();
    }

    @Override
    protected ObjectName registerMBean() {
        ObjectName name = new ObjectNameBuilder("openejb.management").set("j2eeType", "JAX-WS").set("J2EEServer", "openejb").set("J2EEApplication", null).set("EndpointType", "EJB").set("name", this.beanContext.getEjbName()).build();
        this.mbean = new WsServiceMBean(this.beanContext, this.port);
        LocalMBeanServer.registerDynamicWrapperSilently((Object)this.mbean, (ObjectName)name);
        return name;
    }

    @Override
    protected void setWsldUrl(String wsdl) {
        this.mbean.wsdl(wsdl);
    }

    @MBean
    @Description(value="JAX-WS Service information")
    @Internal
    public class WsServiceMBean {
        private final BeanContext beanContext;
        private final PortData port;
        private String wsdl;

        public WsServiceMBean(BeanContext beanContext, PortData port) {
            this.beanContext = beanContext;
            this.port = port;
        }

        @ManagedAttribute
        @Description(value="The service endpoint interface")
        public String getServiceEndpointInterface() {
            return this.beanContext.getServiceEndpointInterface().getName();
        }

        @ManagedAttribute
        @Description(value="The EJB endpoint type")
        public String getComponentType() {
            return this.beanContext.getComponentType().name();
        }

        @ManagedOperation
        @Description(value="Slurp the WSDL")
        public String getWsdl() {
            try {
                return IO.slurp((URL)new URL(this.wsdl));
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }

        @ManagedAttribute
        @Description(value="The WSDL url")
        public String getWsdlUrl() {
            return this.wsdl;
        }

        @ManagedAttribute
        @Description(value="The service port QName")
        public String getPort() {
            return this.port.getPortName().toString();
        }

        @ManagedAttribute
        @Description(value="The service QName")
        public String getService() {
            return this.port.getServiceName().toString();
        }

        @ManagedAttribute
        @Description(value="The handler list")
        public TabularData getHandlers() {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (HandlerChainData handlerChainData : this.port.getHandlerChains()) {
                for (HandlerData handlerData : handlerChainData.getHandlers()) {
                    names.add(handlerChainData.getServiceNamePattern().toString());
                    values.add(handlerData.getHandlerClass().getName());
                }
            }
            return LocalMBeanServer.tabularData((String)"handlers", (String)"The list of handlers", (String[])names.toArray(new String[names.size()]), (Object[])values.toArray(new String[values.size()]));
        }

        @ManagedAttribute
        @Description(value="Is the service secured?")
        public boolean getSecured() {
            return this.port.isSecure();
        }

        @ManagedAttribute
        @Description(value="Is MTOM enabled?")
        public boolean getMtomEnabled() {
            return this.port.isMtomEnabled();
        }

        @ManagedAttribute
        @Description(value="Service configuration properties")
        public TabularData getProperties() {
            return LocalMBeanServer.tabularData((String)"properties", (String)"Service configuration properties", (String)"Service configuration properties", (Properties)this.port.getProperties());
        }

        public void wsdl(String wsdl) {
            this.wsdl = !wsdl.endsWith("?wsdl") ? wsdl + "?wsdl" : wsdl;
        }
    }
}

