/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.util;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;

public final class DateUtil {
    private DateUtil() {
    }

    public static ZonedDateTime parseZonedDateTime(String text, DateTimeFormatter formatter, ZoneId defaultZone) {
        TemporalAccessor parse = formatter.parse(text);
        ZoneId zone = parse.query(TemporalQueries.zone());
        if (zone == null) {
            zone = defaultZone;
        }
        return ZonedDateTime.of(DateUtil.ifSupported(parse, ChronoField.YEAR), DateUtil.ifSupported(parse, ChronoField.MONTH_OF_YEAR), DateUtil.ifSupported(parse, ChronoField.DAY_OF_MONTH), DateUtil.ifSupported(parse, ChronoField.HOUR_OF_DAY), DateUtil.ifSupported(parse, ChronoField.MINUTE_OF_HOUR), DateUtil.ifSupported(parse, ChronoField.SECOND_OF_MINUTE), DateUtil.ifSupported(parse, ChronoField.MILLI_OF_SECOND), zone);
    }

    public static int ifSupported(TemporalAccessor temporal, ChronoField unit) {
        if (temporal.isSupported(unit)) {
            return temporal.get(unit);
        }
        return 0;
    }
}

