/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.rest;

import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import org.apache.openejb.core.security.AbstractSecurityService;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.rest.AbstractRestThreadLocalProxy;
import org.apache.openejb.spi.SecurityService;

public class ThreadLocalSecurityContext
extends AbstractRestThreadLocalProxy<SecurityContext>
implements SecurityContext {
    private final String defaultUser;

    protected ThreadLocalSecurityContext() {
        super(SecurityContext.class);
        SecurityService securityService = ThreadLocalSecurityContext.service();
        this.defaultUser = AbstractSecurityService.class.isInstance(securityService) ? ((AbstractSecurityService)AbstractSecurityService.class.cast(securityService)).getDefaultUser() : null;
    }

    private static SecurityService service() {
        return SystemInstance.get().getComponent(SecurityService.class);
    }

    public String getAuthenticationScheme() {
        return ((SecurityContext)this.get()).getAuthenticationScheme();
    }

    public Principal getUserPrincipal() {
        SecurityContext securityContext;
        Principal callerPrincipal = ThreadLocalSecurityContext.service().getCallerPrincipal();
        if (callerPrincipal == null && (securityContext = (SecurityContext)this.get()) != null) {
            return securityContext.getUserPrincipal();
        }
        return callerPrincipal == null || callerPrincipal.getName().equals(this.defaultUser) ? null : callerPrincipal;
    }

    public boolean isSecure() {
        return ((SecurityContext)this.get()).isSecure();
    }

    public boolean isUserInRole(String role) {
        if (ThreadLocalSecurityContext.service().isCallerInRole(role)) {
            return true;
        }
        SecurityContext sc = (SecurityContext)this.get();
        return sc != null && sc.isUserInRole(role);
    }
}

