/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.cli.SystemExitException;
import org.apache.openejb.util.Classes;

public final class ListSetters {
    public static void main(String[] args) throws Exception {
        CommandLine line;
        Options options = new Options();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withLongOpt((String)"class");
        OptionBuilder.withDescription((String)"the class to introspect");
        options.addOption(OptionBuilder.create((String)"c"));
        try {
            line = new PosixParser().parse(options, args);
        }
        catch (ParseException exp) {
            ListSetters.help(options);
            throw new SystemExitException(-1);
        }
        if (line.hasOption("help")) {
            ListSetters.help(options);
            return;
        }
        String clazz = line.getOptionValue("class");
        List<Class<?>> ancestors = Classes.ancestors(Thread.currentThread().getContextClassLoader().loadClass(clazz));
        LinkedList<String> list = new LinkedList<String>();
        for (Class clazz2 : ancestors) {
            for (Method m : clazz2.getDeclaredMethods()) {
                if (!Modifier.isPublic(m.getModifiers()) || !m.getName().startsWith("set") || m.getGenericParameterTypes().length != 1) continue;
                list.add(m.getName().substring(3));
            }
        }
        Collections.sort(list);
        for (String string : list) {
            System.out.println("- " + string);
        }
    }

    private static void help(Options options) {
        new HelpFormatter().printHelp("setters [options] <value>", "\n", options, "\n");
    }

    private ListSetters() {
    }
}

